/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.log;

import org.apache.tomcat.util.log.LogHandler;
import org.apache.tomcat.util.log.LogManager;

public class Log
implements org.apache.commons.logging.Log {
    public static final int FATAL = Integer.MIN_VALUE;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFORMATION = 3;
    public static final int DEBUG = 4;
    protected String logname;
    protected String prefix;
    private LogHandler proxy;
    private static LogManager logManager = new LogManager();
    static /* synthetic */ Class class$org$apache$tomcat$util$log$LogManager;

    protected Log(String channel, String prefix, LogHandler proxy, Object owner) {
        this.logname = channel;
        this.prefix = prefix;
        this.proxy = proxy;
    }

    public static Log getLog(String channel, String prefix) {
        return logManager.getLog(channel, prefix, null);
    }

    public static Log getLog(String channel, Object owner) {
        return logManager.getLog(channel, null, owner);
    }

    public void log(String msg) {
        this.log(msg, null, 3);
    }

    public void log(String msg, Throwable t) {
        this.log(msg, t, 1);
    }

    public void log(String msg, int level) {
        this.log(msg, null, level);
    }

    public void log(String msg, Throwable t, int level) {
        this.log(this.prefix, msg, t, level);
    }

    public void log(String prefix, String msg, Throwable t, int level) {
        this.proxy.log(prefix, msg, t, level);
    }

    public void flush() {
        this.proxy.flush();
    }

    public void close() {
        this.proxy.close();
    }

    public int getLevel() {
        return this.proxy.getLevel();
    }

    public static LogManager setLogManager(LogManager lm) {
        if (logManager.getClass() == (class$org$apache$tomcat$util$log$LogManager == null ? (class$org$apache$tomcat$util$log$LogManager = Log.class$("org.apache.tomcat.util.log.LogManager")) : class$org$apache$tomcat$util$log$LogManager)) {
            LogManager oldLM = logManager;
            logManager = lm;
            return oldLM;
        }
        return null;
    }

    public String getChannel(LogManager lm) {
        if (lm != logManager) {
            return null;
        }
        return this.logname;
    }

    public void setProxy(LogManager lm, LogHandler l) {
        if (lm != logManager) {
            this.log("Attempt to change proxy " + lm + " " + logManager);
            return;
        }
        this.proxy = l;
    }

    public void debug(Object message) {
        this.log(message.toString(), null, 4);
    }

    public void debug(Object message, Throwable exception) {
        this.log(message.toString(), exception, 4);
    }

    public void error(Object message) {
        this.log(message.toString(), null, 1);
    }

    public void error(Object message, Throwable exception) {
        this.log(message.toString(), exception, 1);
    }

    public void fatal(Object message) {
        this.log(message.toString(), null, Integer.MIN_VALUE);
    }

    public void fatal(Object message, Throwable exception) {
        this.log(message.toString(), exception, Integer.MIN_VALUE);
    }

    public void info(Object message) {
        this.log(message.toString(), null, 3);
    }

    public void info(Object message, Throwable exception) {
        this.log(message.toString(), exception, 3);
    }

    public void trace(Object message) {
        this.log(message.toString(), null, 4);
    }

    public void trace(Object message, Throwable exception) {
        this.log(message.toString(), exception, 4);
    }

    public void warn(Object message) {
        this.log(message.toString(), null, 2);
    }

    public void warn(Object message, Throwable exception) {
        this.log(message.toString(), exception, 2);
    }

    public boolean isDebugEnabled() {
        return this.proxy.getLevel() <= 4;
    }

    public boolean isErrorEnabled() {
        return this.proxy.getLevel() <= 1;
    }

    public boolean isFatalEnabled() {
        return this.proxy.getLevel() <= Integer.MIN_VALUE;
    }

    public boolean isInfoEnabled() {
        return this.proxy.getLevel() <= 3;
    }

    public boolean isTraceEnabled() {
        return this.proxy.getLevel() <= 4;
    }

    public boolean isWarnEnabled() {
        return this.proxy.getLevel() <= 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

