/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.IntermediateInputStream;
import org.apache.tomcat.util.buf.ReadConvertor;

public class B2CConverter {
    private static Log log = LogFactory.getLog(class$org$apache$tomcat$util$buf$B2CConverter == null ? (class$org$apache$tomcat$util$buf$B2CConverter = B2CConverter.class$("org.apache.tomcat.util.buf.B2CConverter")) : class$org$apache$tomcat$util$buf$B2CConverter);
    private IntermediateInputStream iis;
    private ReadConvertor conv;
    private String encoding;
    static final int BUFFER_SIZE = 8192;
    char[] result = new char[8192];
    private final int debug = 0;
    static /* synthetic */ Class class$org$apache$tomcat$util$buf$B2CConverter;

    protected B2CConverter() {
    }

    public B2CConverter(String encoding) throws IOException {
        this.encoding = encoding;
        this.reset();
    }

    public void recycle() {
        this.conv.recycle();
    }

    public void convert(ByteChunk bb, CharChunk cb) throws IOException {
        this.iis.setByteChunk(bb);
        this.convert(cb);
    }

    private void convert(CharChunk cb) throws IOException {
        try {
            while (true) {
                int cnt;
                if ((cnt = this.conv.read(this.result, 0, 8192)) <= 0) {
                    return;
                }
                cb.append(this.result, 0, cnt);
            }
        }
        catch (IOException ex) {
            this.reset();
            throw ex;
        }
    }

    public void reset() throws IOException {
        this.iis = new IntermediateInputStream();
        this.conv = new ReadConvertor(this.iis, this.encoding);
    }

    void log(String s) {
        if (log.isDebugEnabled()) {
            log.debug("B2CConverter: " + s);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

