/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import com.sun.appserv.server.util.PreprocessorUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import org.apache.jasper.security.SecurityUtil;

public class JasperLoader
extends URLClassLoader {
    private PermissionCollection permissionCollection;
    private CodeSource codeSource;
    private String className;
    private ClassLoader parent;
    private SecurityManager securityManager;
    private PrivilegedLoadClass privLoadClass;

    public JasperLoader(URL[] urls, ClassLoader parent, PermissionCollection permissionCollection, CodeSource codeSource) {
        super(urls, parent);
        this.permissionCollection = permissionCollection;
        this.codeSource = codeSource;
        this.parent = parent;
        this.privLoadClass = new PrivilegedLoadClass();
        this.securityManager = System.getSecurityManager();
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public Class loadClass(final String name, boolean resolve) throws ClassNotFoundException {
        int dot;
        Class clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (this.securityManager != null && (dot = name.lastIndexOf(46)) >= 0) {
            try {
                if (!"org.apache.jasper.runtime".equalsIgnoreCase(name.substring(0, dot))) {
                    this.securityManager.checkPackageAccess(name.substring(0, dot));
                }
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                se.printStackTrace();
                throw new ClassNotFoundException(error);
            }
        }
        if (!name.startsWith("org.apache.jsp")) {
            if (this.securityManager != null) {
                final ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(this.privLoadClass);
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return classLoader.loadClass(name);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    Exception rootCause = ex.getException();
                    if (rootCause instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)rootCause;
                    }
                    throw new ClassNotFoundException("JasperLoader", rootCause);
                }
            } else {
                clazz = this.parent.loadClass(name);
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return this.findClass(name);
    }

    public Class findClass(String className) throws ClassNotFoundException {
        if (!PreprocessorUtil.isPreprocessorEnabled()) {
            return super.findClass(className);
        }
        Class<?> clazz = null;
        String path = className.replace('.', '/') + ".class";
        byte[] cdata = this.loadClassDataFromFile(path);
        if (cdata == null) {
            throw new ClassNotFoundException(className);
        }
        cdata = PreprocessorUtil.processClass(path, cdata);
        if (this.securityManager != null) {
            ProtectionDomain pd = new ProtectionDomain(this.codeSource, this.permissionCollection);
            clazz = this.defineClass(className, cdata, 0, cdata.length, pd);
        } else {
            clazz = this.defineClass(className, cdata, 0, cdata.length);
        }
        return clazz;
    }

    private byte[] loadClassDataFromFile(final String fileName) {
        byte[] classBytes = null;
        try {
            InputStream in = null;
            in = SecurityUtil.isPackageProtectionEnabled() ? (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return JasperLoader.this.getResourceAsStream(fileName);
                }
            }) : this.getResourceAsStream(fileName);
            if (in == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = in.read(buf)) != -1) {
                baos.write(buf, 0, i);
            }
            in.close();
            baos.close();
            classBytes = baos.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return classBytes;
    }

    public final PermissionCollection getPermissions(CodeSource codeSource) {
        return this.permissionCollection;
    }

    private class PrivilegedLoadClass
    implements PrivilegedAction {
        private PrivilegedLoadClass() {
        }

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

