/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat5;

import com.sun.appserv.ProxyHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.ValveContext;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.util.StringParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.coyote.tomcat5.Constants;
import org.apache.coyote.tomcat5.CoyoteConnector;
import org.apache.coyote.tomcat5.CoyoteInputStream;
import org.apache.coyote.tomcat5.CoyoteReader;
import org.apache.coyote.tomcat5.CoyoteRequestFacade;
import org.apache.coyote.tomcat5.InputBuffer;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.Parameters;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.http.mapper.MappingData;

public class CoyoteRequest
implements HttpRequest,
HttpServletRequest {
    protected Request coyoteRequest;
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.tomcat5");
    private static final Log log = LogFactory.getLog(class$org$apache$coyote$tomcat5$CoyoteRequest == null ? (class$org$apache$coyote$tomcat5$CoyoteRequest = CoyoteRequest.class$("org.apache.coyote.tomcat5.CoyoteRequest")) : class$org$apache$coyote$tomcat5$CoyoteRequest);
    protected Cookie[] cookies = null;
    protected SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected static Locale defaultLocale = Locale.getDefault();
    protected HashMap attributes = new HashMap();
    private HashMap readOnlyAttributes = new HashMap();
    protected ArrayList locales = new ArrayList();
    private transient HashMap notes = new HashMap();
    protected String authType = null;
    protected Object dispatcherType = null;
    protected InputBuffer inputBuffer = new InputBuffer();
    protected CoyoteInputStream inputStream = new CoyoteInputStream(this.inputBuffer);
    protected CoyoteReader reader = new CoyoteReader(this.inputBuffer);
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    protected Principal userPrincipal = null;
    protected boolean sessionParsed = false;
    protected boolean requestParametersParsed = false;
    protected boolean cookiesParsed = false;
    protected boolean secure = false;
    protected Subject subject = null;
    protected static int CACHED_POST_LEN = 8192;
    protected byte[] postData = null;
    protected ParameterMap parameterMap = new ParameterMap();
    protected Session session = null;
    protected Object requestDispatcherPath = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected Socket socket = null;
    protected boolean localesParsed = false;
    private StringParser parser = new StringParser();
    protected int localPort = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected int remotePort = -1;
    protected String localName = null;
    protected String localAddr = null;
    private int dispatchDepth = 0;
    private static int maxDispatchDepth = 20;
    protected Connector connector;
    protected Context context = null;
    protected FilterChain filterChain = null;
    protected static final String info = "org.apache.coyote.catalina.CoyoteRequest/1.0";
    protected MappingData mappingData = new MappingData();
    protected CoyoteRequestFacade facade = null;
    protected Response response = null;
    protected B2CConverter URIConverter = null;
    protected ValveContext valveContext = null;
    protected Wrapper wrapper = null;
    static /* synthetic */ Class class$org$apache$coyote$tomcat5$CoyoteRequest;

    public CoyoteRequest() {
        this.formats[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[1].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[2].setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void setCoyoteRequest(Request coyoteRequest) {
        this.coyoteRequest = coyoteRequest;
        this.inputBuffer.setRequest(coyoteRequest);
    }

    public Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    public void recycle() {
        this.context = null;
        this.wrapper = null;
        this.dispatcherType = null;
        this.requestDispatcherPath = null;
        this.authType = null;
        this.inputBuffer.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.userPrincipal = null;
        this.subject = null;
        this.sessionParsed = false;
        this.requestParametersParsed = false;
        this.cookiesParsed = false;
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
        this.attributes.clear();
        this.notes.clear();
        this.cookies = null;
        if (this.session != null) {
            this.session.endAccess();
        }
        this.session = null;
        this.requestedSessionCookie = false;
        this.requestedSessionId = null;
        this.requestedSessionURL = false;
        this.dispatchDepth = 0;
        this.parameterMap.setLocked(false);
        this.parameterMap.clear();
        this.mappingData.recycle();
        if (Constants.SECURITY) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.inputStream != null) {
                this.inputStream.clear();
                this.inputStream = null;
            }
            if (this.reader != null) {
                this.reader.clear();
                this.reader = null;
            }
        }
    }

    public String getAuthorization() {
        return this.coyoteRequest.getHeader("authorization");
    }

    public void setAuthorization(String authorization) {
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    public void setFilterChain(FilterChain filterChain) {
        this.filterChain = filterChain;
    }

    public Host getHost() {
        if (this.getContext() == null) {
            return null;
        }
        return (Host)this.getContext().getParent();
    }

    public void setHost(Host host) {
        this.mappingData.host = host;
    }

    public String getInfo() {
        return info;
    }

    public MappingData getMappingData() {
        return this.mappingData;
    }

    public ServletRequest getRequest() {
        if (this.facade == null) {
            this.facade = new CoyoteRequestFacade(this);
        }
        return this.facade;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
        this.remoteHost = null;
        this.remoteAddr = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
    }

    public InputStream getStream() {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public void setStream(InputStream stream) {
    }

    protected B2CConverter getURIConverter() {
        return this.URIConverter;
    }

    protected void setURIConverter(B2CConverter URIConverter) {
        this.URIConverter = URIConverter;
    }

    public ValveContext getValveContext() {
        return this.valveContext;
    }

    public void setValveContext(ValveContext valveContext) {
        this.valveContext = valveContext;
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public ServletInputStream createInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public void finishRequest() throws IOException {
    }

    public Object getNote(String name) {
        return this.notes.get(name);
    }

    public Iterator getNoteNames() {
        return this.notes.keySet().iterator();
    }

    public void removeNote(String name) {
        this.notes.remove(name);
    }

    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    public void setContentLength(int length) {
    }

    public void setContentType(String type) {
    }

    public void setProtocol(String protocol) {
    }

    public void setRemoteAddr(String remoteAddr) {
    }

    public void setRemoteHost(String remoteHost) {
    }

    public void setScheme(String scheme) {
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServerName(String name) {
        this.coyoteRequest.serverName().setString(name);
    }

    public void setServerPort(int port) {
        this.coyoteRequest.setServerPort(port);
    }

    public Object getAttribute(String name) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            return this.dispatcherType == null ? ApplicationFilterFactory.REQUEST_INTEGER : this.dispatcherType;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            return this.requestDispatcherPath == null ? this.getRequestPathMB().toString() : this.requestDispatcherPath.toString();
        }
        Object attr = this.attributes.get(name);
        if (attr != null) {
            return attr;
        }
        attr = this.coyoteRequest.getAttribute(name);
        if (attr != null) {
            return attr;
        }
        if ("org.apache.coyote.request.X509Certificate".equals(name)) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_SSL_CERTIFICATE, null);
            attr = this.getAttribute("javax.servlet.request.X509Certificate");
            if (attr != null) {
                this.attributes.put(name, attr);
            }
        } else if (CoyoteRequest.isSSLAttribute(name)) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_SSL_ATTRIBUTE, this.coyoteRequest);
            attr = this.coyoteRequest.getAttribute("javax.servlet.request.X509Certificate");
            if (attr != null) {
                this.attributes.put("javax.servlet.request.X509Certificate", attr);
            }
            if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.cipher_suite")) != null) {
                this.attributes.put("javax.servlet.request.cipher_suite", attr);
            }
            if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.key_size")) != null) {
                this.attributes.put("javax.servlet.request.key_size", attr);
            }
            attr = this.attributes.get(name);
        }
        return attr;
    }

    static boolean isSSLAttribute(String name) {
        return "javax.servlet.request.X509Certificate".equals(name) || "javax.servlet.request.cipher_suite".equals(name) || "javax.servlet.request.key_size".equals(name);
    }

    public Enumeration getAttributeNames() {
        return new Enumerator(this.attributes.keySet(), true);
    }

    public String getCharacterEncoding() {
        return this.coyoteRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.coyoteRequest.getContentLength();
    }

    public String getContentType() {
        return this.coyoteRequest.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getInputStream.ise"));
        }
        this.usingInputStream = true;
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public Locale getLocale() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return (Locale)this.locales.get(0);
        }
        return defaultLocale;
    }

    public Enumeration getLocales() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return new Enumerator(this.locales);
        }
        ArrayList<Locale> results = new ArrayList<Locale>();
        results.add(defaultLocale);
        return new Enumerator(results);
    }

    public String getParameter(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.coyoteRequest.getParameters().getParameter(name);
    }

    public Map getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        Enumeration enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement().toString();
            String[] values = this.getParameterValues(name);
            this.parameterMap.put(name, values);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.coyoteRequest.getParameters().getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.coyoteRequest.getParameters().getParameterValues(name);
    }

    public String getProtocol() {
        return this.coyoteRequest.protocol().toString();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getReader.ise"));
        }
        this.usingReader = true;
        this.inputBuffer.checkConverter();
        if (this.reader == null) {
            this.reader = new CoyoteReader(this.inputBuffer);
        }
        return this.reader;
    }

    public String getRealPath(String path) {
        if (this.context == null) {
            return null;
        }
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext == null) {
            return null;
        }
        try {
            return servletContext.getRealPath(path);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            if (this.connector.getAuthPassthroughEnabled() && this.connector.getProxyHandler() != null) {
                this.remoteAddr = this.connector.getProxyHandler().getRemoteAddress((HttpServletRequest)this.getRequest());
                if (this.remoteAddr == null) {
                    log.warn(sm.getString("coyoteRequest.nullRemoteAddressFromProxy"));
                }
                return this.remoteAddr;
            }
            if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteAddr = inet.getHostAddress();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE, this.coyoteRequest);
                this.remoteAddr = this.coyoteRequest.remoteAddr().toString();
            }
        }
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (!this.connector.getEnableLookups()) {
                this.remoteHost = this.getRemoteAddr();
            } else if (this.connector.getAuthPassthroughEnabled() && this.connector.getProxyHandler() != null) {
                String addr = this.connector.getProxyHandler().getRemoteAddress((HttpServletRequest)this.getRequest());
                if (addr != null) {
                    try {
                        this.remoteHost = InetAddress.getByName(addr).getHostName();
                    }
                    catch (UnknownHostException e) {
                        log.warn(sm.getString("coyoteRequest.unknownHost", addr), e);
                    }
                } else {
                    log.warn(sm.getString("coyoteRequest.nullRemoteAddressFromProxy"));
                }
            } else if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteHost = inet.getHostName();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_HOST_ATTRIBUTE, this.coyoteRequest);
                this.remoteHost = this.coyoteRequest.remoteHost().toString();
            }
        }
        return this.remoteHost;
    }

    public int getRemotePort() {
        if (this.remotePort == -1) {
            if (this.socket != null) {
                this.remotePort = this.socket.getPort();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE, this.coyoteRequest);
                this.remotePort = this.coyoteRequest.getRemotePort();
            }
        }
        return this.remotePort;
    }

    public String getLocalName() {
        if (this.localName == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getLocalAddress();
                this.localName = inet.getHostName();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE, this.coyoteRequest);
                this.localName = this.coyoteRequest.localName().toString();
            }
        }
        return this.localName;
    }

    public String getLocalAddr() {
        if (this.localAddr == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getLocalAddress();
                this.localAddr = inet.getHostAddress();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE, this.coyoteRequest);
                this.localAddr = this.coyoteRequest.localAddr().toString();
            }
        }
        return this.localAddr;
    }

    public int getLocalPort() {
        if (this.localPort == -1) {
            if (this.socket != null) {
                this.localPort = this.socket.getLocalPort();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE, this.coyoteRequest);
                this.localPort = this.coyoteRequest.getLocalPort();
            }
        }
        return this.localPort;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.context == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.context.getServletContext().getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String pathInfo = this.getPathInfo();
        String requestPath = null;
        requestPath = pathInfo == null ? servletPath : servletPath + pathInfo;
        int pos = requestPath.lastIndexOf(47);
        String relative = null;
        relative = pos >= 0 ? RequestUtil.normalize(requestPath.substring(0, pos + 1) + path) : RequestUtil.normalize(requestPath + path);
        return this.context.getServletContext().getRequestDispatcher(relative);
    }

    public String getScheme() {
        ProxyHandler proxyHandler;
        if (this.getConnector() != null && this.getConnector().getAuthPassthroughEnabled() && this.getRequest() instanceof HttpServletRequest && (proxyHandler = this.getConnector().getProxyHandler()) != null && proxyHandler.getSSLKeysize((HttpServletRequest)this.getRequest()) > 0) {
            return "https";
        }
        return this.coyoteRequest.scheme().toString();
    }

    public String getServerName() {
        return this.coyoteRequest.serverName().toString();
    }

    public int getServerPort() {
        return this.coyoteRequest.getServerPort();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void removeAttribute(String name) {
        Object value = null;
        boolean found = false;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        found = this.attributes.containsKey(name);
        if (!found) {
            return;
        }
        value = this.attributes.get(name);
        this.attributes.remove(name);
        Object[] listeners = this.context.getApplicationEventListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.context.getServletContext(), this.getRequest(), name, value);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners[i];
            try {
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                this.log(sm.getString("coyoteRequest.attributeEvent"), t);
                this.attributes.put("javax.servlet.error.exception", t);
            }
        }
    }

    public void setAttribute(String name, Object value) {
        Object[] listeners;
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("coyoteRequest.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherType = value;
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        Object oldValue = null;
        boolean replaced = false;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        oldValue = this.attributes.put(name, value);
        if (oldValue != null) {
            replaced = true;
        }
        if ((listeners = this.context.getApplicationEventListeners()) == null || listeners.length == 0) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        event = replaced ? new ServletRequestAttributeEvent(this.context.getServletContext(), this.getRequest(), name, oldValue) : new ServletRequestAttributeEvent(this.context.getServletContext(), this.getRequest(), name, value);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners[i];
            try {
                if (replaced) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                this.log(sm.getString("coyoteRequest.attributeEvent"), t);
                this.attributes.put("javax.servlet.error.exception", t);
            }
        }
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        byte[] buffer = new byte[]{97};
        final byte[] finalBuffer = buffer;
        final String finalEnc = enc;
        String dummy = null;
        if (System.getSecurityManager() != null) {
            try {
                dummy = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnsupportedEncodingException {
                        return new String(finalBuffer, finalEnc);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (UnsupportedEncodingException)pae.getCause();
            }
        } else {
            dummy = new String(buffer, enc);
        }
        this.coyoteRequest.setCharacterEncoding(enc);
    }

    public static void setMaxDispatchDepth(int depth) {
        maxDispatchDepth = depth;
    }

    public static int getMaxDispatchDepth() {
        return maxDispatchDepth;
    }

    public int incrementDispatchDepth() {
        return ++this.dispatchDepth;
    }

    public int decrementDispatchDepth() {
        return --this.dispatchDepth;
    }

    public boolean isMaxDispatchDepthReached() {
        return this.dispatchDepth > maxDispatchDepth;
    }

    public void addCookie(Cookie cookie) {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        int size = 0;
        if (this.cookies != null) {
            size = this.cookies.length;
        }
        Cookie[] newCookies = new Cookie[size + 1];
        for (int i = 0; i < size; ++i) {
            newCookies[i] = this.cookies[i];
        }
        newCookies[size] = cookie;
        this.cookies = newCookies;
    }

    public void addHeader(String name, String value) {
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void addParameter(String name, String[] values) {
        this.coyoteRequest.getParameters().addParameterValues(name, values);
    }

    public void clearCookies() {
        this.cookiesParsed = true;
        this.cookies = null;
    }

    public void clearHeaders() {
    }

    public void clearLocales() {
        this.locales.clear();
    }

    public void clearParameters() {
    }

    public void setAuthType(String type) {
        this.authType = type;
    }

    public void setContextPath(String path) {
        if (path == null) {
            this.mappingData.contextPath.setString("");
        } else {
            this.mappingData.contextPath.setString(path);
        }
    }

    public void setMethod(String method) {
    }

    public void setQueryString(String query) {
    }

    public void setPathInfo(String path) {
        this.mappingData.pathInfo.setString(path);
    }

    public void setRequestedSessionCookie(boolean flag) {
        this.requestedSessionCookie = flag;
    }

    public void setRequestedSessionId(String id) {
        this.requestedSessionId = id;
    }

    public void setRequestedSessionURL(boolean flag) {
        this.requestedSessionURL = flag;
    }

    public void setRequestURI(String uri) {
    }

    public void setDecodedRequestURI(String uri) {
    }

    public String getDecodedRequestURI() {
        return this.coyoteRequest.decodedURI().toString();
    }

    public MessageBytes getDecodedRequestURIMB() {
        return this.coyoteRequest.decodedURI();
    }

    public void setServletPath(String path) {
        if (path != null) {
            this.mappingData.wrapperPath.setString(path);
        }
    }

    public void setUserPrincipal(Principal principal) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            HttpSession session = this.getSession(false);
            if (this.subject != null && !this.subject.getPrincipals().contains(principal)) {
                this.subject.getPrincipals().add(principal);
            } else if (session != null && session.getAttribute("javax.security.auth.subject") == null) {
                this.subject = new Subject();
                this.subject.getPrincipals().add(principal);
            }
            if (session != null) {
                session.setAttribute("javax.security.auth.subject", (Object)this.subject);
            }
        }
        this.userPrincipal = principal;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        return this.mappingData.contextPath.toString();
    }

    public MessageBytes getContextPathMB() {
        return this.mappingData.contextPath;
    }

    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate(value, this.formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public String getHeader(String name) {
        return this.coyoteRequest.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.coyoteRequest.getMimeHeaders().values(name);
    }

    public Enumeration getHeaderNames() {
        return this.coyoteRequest.getMimeHeaders().names();
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getMethod() {
        return this.coyoteRequest.method().toString();
    }

    public String getPathInfo() {
        return this.mappingData.pathInfo.toString();
    }

    public MessageBytes getPathInfoMB() {
        return this.mappingData.pathInfo;
    }

    public String getPathTranslated() {
        if (this.context == null) {
            return null;
        }
        if (this.getPathInfo() == null) {
            return null;
        }
        return this.context.getServletContext().getRealPath(this.getPathInfo());
    }

    public String getQueryString() {
        String queryString = this.coyoteRequest.queryString().toString();
        if (queryString == null || queryString.equals("")) {
            return null;
        }
        return queryString;
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public MessageBytes getRequestPathMB() {
        return this.mappingData.requestPath;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.coyoteRequest.requestURI().toString();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getServletPath() {
        return this.mappingData.wrapperPath.toString();
    }

    public MessageBytes getServletPathMB() {
        return this.mappingData.wrapperPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        return this.doGetSession(create);
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionCookie;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionURL;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return false;
        }
        Session session = null;
        try {
            session = manager.findSession(this.requestedSessionId);
        }
        catch (IOException e) {
            session = null;
        }
        return session != null && session.isValid();
    }

    public boolean isUserInRole(String role) {
        String realRole;
        if (this.userPrincipal == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Realm realm = this.context.getRealm();
        if (realm == null) {
            return false;
        }
        if (this.wrapper != null && (realRole = this.wrapper.findSecurityReference(role)) != null && realm.hasRole(this.userPrincipal, realRole)) {
            return true;
        }
        return realm.hasRole(this.userPrincipal, role);
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    protected HttpSession doGetSession(boolean create) {
        if (this.context == null) {
            return null;
        }
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session.getSession();
        }
        Manager manager = null;
        if (this.context != null) {
            manager = this.context.getManager();
        }
        if (manager == null) {
            return null;
        }
        if (this.requestedSessionId != null) {
            try {
                this.session = manager.findSession(this.requestedSessionId);
            }
            catch (IOException e) {
                this.session = null;
            }
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                this.session.access();
                return this.session.getSession();
            }
        }
        if (!create) {
            return null;
        }
        if (this.context != null && this.response != null && this.context.getCookies() && this.response.getResponse().isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteRequest.sessionCreateCommitted"));
        }
        this.session = this.requestedSessionId != null && this.context.getReuseSessionID() ? manager.createSession(this.requestedSessionId) : manager.createSession();
        if (this.session != null && this.getContext() != null && this.getContext().getCookies()) {
            Cookie cookie = new Cookie("JSESSIONID", this.session.getId());
            this.configureSessionCookie(cookie);
            ((HttpServletResponse)this.response).addCookie(cookie);
        }
        if (this.session != null) {
            this.session.access();
            return this.session.getSession();
        }
        return null;
    }

    protected void configureSessionCookie(Cookie cookie) {
        cookie.setMaxAge(-1);
        String contextPath = null;
        if (this.getContext() != null) {
            contextPath = this.getContext().getPath();
        }
        if (contextPath != null && contextPath.length() > 0) {
            cookie.setPath(contextPath);
        } else {
            cookie.setPath("/");
        }
        if (this.isSecure()) {
            cookie.setSecure(true);
        }
    }

    protected void parseCookies() {
        this.cookiesParsed = true;
        Cookies serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        this.cookies = new Cookie[count];
        int idx = 0;
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            try {
                Cookie cookie = new Cookie(scookie.getName().toString(), scookie.getValue().toString());
                cookie.setPath(scookie.getPath().toString());
                cookie.setVersion(scookie.getVersion());
                String domain = scookie.getDomain().toString();
                if (domain != null) {
                    cookie.setDomain(scookie.getDomain().toString());
                }
                this.cookies[idx++] = cookie;
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (idx < count) {
            Cookie[] ncookies = new Cookie[idx];
            System.arraycopy(this.cookies, 0, ncookies, 0, idx);
            this.cookies = ncookies;
        }
    }

    protected void parseRequestParameters() {
        int semicolon;
        this.requestParametersParsed = true;
        Parameters parameters = this.coyoteRequest.getParameters();
        String enc = this.getCharacterEncoding();
        if (enc != null) {
            parameters.setEncoding(enc);
            parameters.setQueryStringEncoding(enc);
        } else {
            parameters.setEncoding("ISO-8859-1");
            parameters.setQueryStringEncoding("ISO-8859-1");
        }
        parameters.handleQueryParameters();
        if (this.usingInputStream || this.usingReader) {
            return;
        }
        if (!this.getMethod().equalsIgnoreCase("POST")) {
            return;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if (!"application/x-www-form-urlencoded".equals(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim())) {
            return;
        }
        int len = this.getContentLength();
        if (len > 0) {
            int maxPostSize = ((CoyoteConnector)this.connector).getMaxPostSize();
            if (maxPostSize > 0 && len > maxPostSize) {
                this.log(sm.getString("coyoteRequest.postTooLarge"));
                throw new IllegalStateException("Post too large");
            }
            try {
                byte[] formData = this.getPostBody();
                if (formData != null) {
                    parameters.processParameters(formData, 0, len);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    protected byte[] getPostBody() throws IOException {
        int len = this.getContentLength();
        byte[] formData = null;
        if (len < CACHED_POST_LEN) {
            if (this.postData == null) {
                this.postData = new byte[CACHED_POST_LEN];
            }
            formData = this.postData;
        } else {
            formData = new byte[len];
        }
        int actualLen = this.readPostBody(formData, len);
        if (actualLen == len) {
            return formData;
        }
        return null;
    }

    protected int readPostBody(byte[] body, int len) throws IOException {
        int inputLen;
        int offset = 0;
        do {
            if ((inputLen = this.getStream().read(body, offset, len - offset)) > 0) continue;
            return offset;
        } while (len - (offset += inputLen) > 0);
        return len;
    }

    protected void parseLocales() {
        this.localesParsed = true;
        Enumeration values = this.getHeaders("accept-language");
        while (values.hasMoreElements()) {
            String value = values.nextElement().toString();
            this.parseLocalesHeader(value);
        }
    }

    protected void parseLocalesHeader(String value) {
        int start;
        TreeMap<Double, ArrayList<Locale>> locales = new TreeMap<Double, ArrayList<Locale>>();
        int white = value.indexOf(32);
        if (white < 0) {
            white = value.indexOf(9);
        }
        if (white >= 0) {
            StringBuffer sb = new StringBuffer();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                if (ch == ' ' || ch == '\t') continue;
                sb.append(ch);
            }
            value = sb.toString();
        }
        this.parser.setString(value);
        int length = this.parser.getLength();
        while ((start = this.parser.getIndex()) < length) {
            int end = this.parser.findChar(',');
            String entry = this.parser.extract(start, end).trim();
            this.parser.advance();
            double quality = 1.0;
            int semi = entry.indexOf(";q=");
            if (semi >= 0) {
                try {
                    quality = Double.parseDouble(entry.substring(semi + 3));
                }
                catch (NumberFormatException e) {
                    quality = 0.0;
                }
                entry = entry.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry)) continue;
            String language = null;
            String country = null;
            String variant = null;
            int dash = entry.indexOf(45);
            if (dash < 0) {
                language = entry;
                country = "";
                variant = "";
            } else {
                language = entry.substring(0, dash);
                country = entry.substring(dash + 1);
                int vDash = country.indexOf(45);
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                } else {
                    variant = "";
                }
            }
            Locale locale = new Locale(language, country, variant);
            Double key = new Double(-quality);
            ArrayList<Locale> values = (ArrayList<Locale>)locales.get(key);
            if (values == null) {
                values = new ArrayList<Locale>();
                locales.put(key, values);
            }
            values.add(locale);
        }
        Iterator keys = locales.keySet().iterator();
        while (keys.hasNext()) {
            Double key = (Double)keys.next();
            ArrayList list = (ArrayList)locales.get(key);
            Iterator values = list.iterator();
            while (values.hasNext()) {
                Locale locale = (Locale)values.next();
                this.addLocale(locale);
            }
        }
    }

    private void log(String message) {
        Logger logger = this.connector.getContainer().getLogger();
        String localName = "CoyoteRequest";
        if (logger != null) {
            logger.log(localName + " " + message);
        } else {
            System.out.println(localName + " " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.connector.getContainer().getLogger();
        String localName = "CoyoteRequest";
        if (logger != null) {
            logger.log(localName + " " + message, throwable);
        } else {
            System.out.println(localName + " " + message);
            throwable.printStackTrace(System.out);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

