/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.Http11Processor;
import org.apache.tomcat.util.net.PoolTcpEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.TcpConnection;
import org.apache.tomcat.util.net.TcpConnectionHandler;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ThreadPool;
import org.apache.tomcat.util.threads.ThreadWithAttributes;

public class Http11Protocol
implements ProtocolHandler,
MBeanRegistration {
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.http11");
    ObjectName tpOname;
    ObjectName rgOname;
    protected ThreadPool tp = ThreadPool.createThreadPool(true);
    protected PoolTcpEndpoint ep = new PoolTcpEndpoint(this.tp);
    protected boolean secure;
    protected ServerSocketFactory socketFactory;
    protected SSLImplementation sslImplementation;
    protected Hashtable attributes = new Hashtable();
    protected String socketFactoryName = null;
    protected String sslImplementationName = null;
    private int maxKeepAliveRequests = 100;
    private int timeout = 300000;
    private int maxPostSize = 0x200000;
    private int maxHttpHeaderSize = 4096;
    private String reportedname;
    private int socketCloseDelay = -1;
    private boolean disableUploadTimeout = true;
    private Adapter adapter;
    private Http11ConnectionHandler cHandler = new Http11ConnectionHandler(this);
    private int requestBufferSize = 4096;
    private String compression = "off";
    public static final int THREAD_DATA_PROCESSOR = 1;
    public static final int THREAD_DATA_OBJECT_NAME = 2;
    protected static Log log = LogFactory.getLog(class$org$apache$coyote$http11$Http11Protocol == null ? (class$org$apache$coyote$http11$Http11Protocol = Http11Protocol.class$("org.apache.coyote.http11.Http11Protocol")) : class$org$apache$coyote$http11$Http11Protocol);
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;
    static /* synthetic */ Class class$org$apache$coyote$http11$Http11Protocol;

    public Http11Protocol() {
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setServerSoTimeout(0);
        this.setTcpNoDelay(true);
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int valueI) {
        this.maxHttpHeaderSize = valueI;
        this.setAttribute("maxHttpHeaderSize", "" + valueI);
    }

    public void setAttribute(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("http11protocol.setattribute", name, value));
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String key) {
        return null;
    }

    public void setProperty(String name, String value) {
        this.setAttribute(name, value);
    }

    public String getProperty(String name) {
        return (String)this.getAttribute(name);
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void init() throws Exception {
        this.ep.setConnectionHandler(this.cHandler);
        try {
            this.checkSocketFactory();
        }
        catch (Exception ex) {
            log.error(sm.getString("http11protocol.socketfactory.initerror"), ex);
            throw ex;
        }
        if (this.socketFactory != null) {
            Enumeration attE = this.attributes.keys();
            while (attE.hasMoreElements()) {
                String key = (String)attE.nextElement();
                Object v = this.attributes.get(key);
                this.socketFactory.setAttribute(key, v);
            }
        }
        try {
            this.ep.initEndpoint();
        }
        catch (Exception ex) {
            log.error(sm.getString("http11protocol.endpoint.initerror"), ex);
            throw ex;
        }
        log.info(sm.getString("http11protocol.init", "" + this.ep.getPort()));
    }

    public void start() throws Exception {
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=http" + this.ep.getPort());
                Registry.getRegistry().registerComponent((Object)this.tp, this.tpOname, null);
                this.tp.setName("http" + this.ep.getPort());
                this.tp.addThreadPoolListener(new MXPoolListener(this, this.tp));
            }
            catch (Exception e) {
                log.error("Can't register threadpool");
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=http" + this.ep.getPort());
            Registry.getRegistry().registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.ep.startEndpoint();
        }
        catch (Exception ex) {
            log.error(sm.getString("http11protocol.endpoint.starterror"), ex);
            throw ex;
        }
        log.info(sm.getString("http11protocol.start", "" + this.ep.getPort()));
    }

    public void destroy() throws Exception {
        log.info("Stoping http11 protocol on " + this.ep.getPort() + " " + this.tpOname);
        this.ep.stopEndpoint();
        if (this.tpOname != null) {
            Registry.getRegistry().unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry().unregisterComponent(this.rgOname);
        }
    }

    public boolean getPools() {
        return this.ep.isPoolOn();
    }

    public void setPools(boolean t) {
        this.ep.setPoolOn(t);
        this.setAttribute("pools", "" + t);
    }

    public int getMaxThreads() {
        return this.ep.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.ep.setMaxThreads(maxThreads);
        this.setAttribute("maxThreads", "" + maxThreads);
    }

    public int getMaxSpareThreads() {
        return this.ep.getMaxSpareThreads();
    }

    public void setMaxSpareThreads(int maxThreads) {
        this.ep.setMaxSpareThreads(maxThreads);
        this.setAttribute("maxSpareThreads", "" + maxThreads);
    }

    public int getMinSpareThreads() {
        return this.ep.getMinSpareThreads();
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.ep.setMinSpareThreads(minSpareThreads);
        this.setAttribute("minSpareThreads", "" + minSpareThreads);
    }

    public int getBacklog() {
        return this.ep.getBacklog();
    }

    public void setBacklog(int i) {
        this.ep.setBacklog(i);
        this.setAttribute("backlog", "" + i);
    }

    public int getPort() {
        return this.ep.getPort();
    }

    public void setPort(int port) {
        this.ep.setPort(port);
        this.setAttribute("port", "" + port);
    }

    public InetAddress getAddress() {
        return this.ep.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.ep.setAddress(ia);
        this.setAttribute("address", "" + ia);
    }

    public String getSocketFactory() {
        return this.socketFactoryName;
    }

    public void setSocketFactory(String valueS) {
        this.socketFactoryName = valueS;
        this.setAttribute("socketFactory", valueS);
    }

    public String getSSLImplementation() {
        return this.sslImplementationName;
    }

    public void setSSLImplementation(String valueS) {
        this.sslImplementationName = valueS;
        this.setAttribute("sslImplementation", valueS);
    }

    public boolean getTcpNoDelay() {
        return this.ep.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean b) {
        this.ep.setTcpNoDelay(b);
        this.setAttribute("tcpNoDelay", "" + b);
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int valueI) {
        this.maxPostSize = valueI;
        this.setAttribute("maxPostSize", "" + valueI);
    }

    public int getSoLinger() {
        return this.ep.getSoLinger();
    }

    public void setSoLinger(int i) {
        this.ep.setSoLinger(i);
        this.setAttribute("soLinger", "" + i);
    }

    public int getSoTimeout() {
        return this.ep.getSoTimeout();
    }

    public void setSoTimeout(int i) {
        this.ep.setSoTimeout(i);
        this.setAttribute("soTimeout", "" + i);
    }

    public int getServerSoTimeout() {
        return this.ep.getServerSoTimeout();
    }

    public void setServerSoTimeout(int i) {
        this.ep.setServerSoTimeout(i);
        this.setAttribute("serverSoTimeout", "" + i);
    }

    public String getKeystore() {
        return this.getProperty("keystore");
    }

    public void setKeystore(String k) {
        this.setAttribute("keystore", k);
    }

    public String getKeypass() {
        return this.getProperty("keypass");
    }

    public void setKeypass(String k) {
        this.attributes.put("keypass", k);
    }

    public String getKeytype() {
        return this.getProperty("keystoreType");
    }

    public void setKeytype(String k) {
        this.setAttribute("keystoreType", k);
    }

    public String getClientauth() {
        return this.getProperty("clientauth");
    }

    public void setClientauth(String k) {
        this.setAttribute("clientauth", k);
    }

    public String getProtocol() {
        return this.getProperty("protocol");
    }

    public void setProtocol(String k) {
        this.setAttribute("protocol", k);
    }

    public String getProtocols() {
        return this.getProperty("protocols");
    }

    public void setProtocols(String k) {
        this.setAttribute("protocols", k);
    }

    public String getAlgorithm() {
        return this.getProperty("algorithm");
    }

    public void setAlgorithm(String k) {
        this.setAttribute("algorithm", k);
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
        this.setAttribute("secure", "" + b);
    }

    public String getCiphers() {
        return this.getProperty("ciphers");
    }

    public void setCiphers(String ciphers) {
        this.setAttribute("ciphers", ciphers);
    }

    public String getKeyAlias() {
        return this.getProperty("keyAlias");
    }

    public void setKeyAlias(String keyAlias) {
        this.setAttribute("keyAlias", keyAlias);
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
        this.setAttribute("maxKeepAliveRequests", "" + mkar);
    }

    public int getSocketCloseDelay() {
        return this.socketCloseDelay;
    }

    public void setSocketCloseDelay(int d) {
        this.socketCloseDelay = d;
        this.setAttribute("socketCloseDelay", "" + d);
    }

    private static ServerSocketFactory string2SocketFactory(String val) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> chC = Class.forName(val);
        return (ServerSocketFactory)chC.newInstance();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts * 1000;
        this.setAttribute("timeout", "" + timeouts);
    }

    public String getReportedname() {
        return this.reportedname;
    }

    public void setReportedname(String reportedName) {
        this.reportedname = reportedName;
    }

    private void checkSocketFactory() throws Exception {
        if (this.secure) {
            this.sslImplementation = SSLImplementation.getInstance(this.sslImplementationName);
            this.socketFactory = this.sslImplementation.getServerSocketFactory();
            this.ep.setServerSocketFactory(this.socketFactory);
        }
        if (this.socketFactoryName != null) {
            this.socketFactory = Http11Protocol.string2SocketFactory(this.socketFactoryName);
            this.ep.setServerSocketFactory(this.socketFactory);
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void setBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getBufferSize() {
        return this.requestBufferSize;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Http11ConnectionHandler
    implements TcpConnectionHandler {
        Http11Protocol proto;
        static int count = 0;
        RequestGroupInfo global = new RequestGroupInfo();

        Http11ConnectionHandler(Http11Protocol proto) {
            this.proto = proto;
        }

        public void setAttribute(String name, Object value) {
        }

        public void setServer(Object o) {
        }

        public Object[] init() {
            Object[] thData = new Object[3];
            Http11Processor processor = new Http11Processor(this.proto.maxHttpHeaderSize);
            processor.setAdapter(this.proto.adapter);
            processor.setThreadPool(this.proto.tp);
            processor.setMaxKeepAliveRequests(this.proto.maxKeepAliveRequests);
            processor.setTimeout(this.proto.timeout);
            processor.setDisableUploadTimeout(this.proto.disableUploadTimeout);
            processor.setCompression(this.proto.compression);
            processor.setMaxPostSize(this.proto.maxPostSize);
            processor.setBufferSize(this.proto.requestBufferSize);
            thData[1] = processor;
            if (this.proto.getDomain() != null) {
                try {
                    RequestInfo rp = processor.getRequest().getRequestProcessor();
                    rp.setGlobalProcessor(this.global);
                    ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=http" + this.proto.ep.getPort() + ",name=HttpRequest" + count++);
                    Registry.getRegistry().registerComponent((Object)rp, rpName, null);
                    thData[2] = rpName;
                }
                catch (Exception ex) {
                    log.warn("Error registering request");
                }
            }
            return thData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void processConnection(TcpConnection connection, Object[] thData) {
            block29: {
                Socket socket = null;
                Http11Processor processor = null;
                processor = (Http11Processor)thData[1];
                if (processor instanceof ActionHook) {
                    processor.action(ActionCode.ACTION_START, null);
                }
                socket = connection.getSocket();
                InputStream in = socket.getInputStream();
                OutputStream out = socket.getOutputStream();
                if (this.proto.secure) {
                    SSLSupport sslSupport = null;
                    if (this.proto.sslImplementation != null) {
                        sslSupport = this.proto.sslImplementation.getSSLSupport(socket);
                    }
                    processor.setSSLSupport(sslSupport);
                } else {
                    processor.setSSLSupport(null);
                }
                processor.setSocket(socket);
                processor.process(in, out);
                if (this.proto.socketCloseDelay >= 0) {
                    try {
                        Thread.sleep(this.proto.socketCloseDelay);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                TcpConnection.shutdownInput(socket);
                Object var9_12 = null;
                if (processor instanceof ActionHook) {
                    processor.action(ActionCode.ACTION_STOP, null);
                }
                try {
                    if (socket != null) {
                        socket.close();
                    }
                    break block29;
                }
                catch (IOException e2) {}
                break block29;
                {
                    catch (SocketException e) {
                        log.debug(sm.getString("http11protocol.proto.socketexception.debug"), e);
                        Object var9_13 = null;
                        if (processor instanceof ActionHook) {
                            processor.action(ActionCode.ACTION_STOP, null);
                        }
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                            break block29;
                        }
                        catch (IOException e2) {}
                        break block29;
                    }
                    catch (IOException e) {
                        log.debug(sm.getString("http11protocol.proto.ioexception.debug"), e);
                        Object var9_14 = null;
                        if (processor instanceof ActionHook) {
                            processor.action(ActionCode.ACTION_STOP, null);
                        }
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                            break block29;
                        }
                        catch (IOException e2) {}
                        break block29;
                    }
                    catch (Throwable e) {
                        log.error(sm.getString("http11protocol.proto.error"), e);
                        Object var9_15 = null;
                        if (processor instanceof ActionHook) {
                            processor.action(ActionCode.ACTION_STOP, null);
                        }
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                            break block29;
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    if (processor instanceof ActionHook) {
                        processor.action(ActionCode.ACTION_STOP, null);
                    }
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    static class MXPoolListener
    implements ThreadPool.ThreadPoolListener {
        MXPoolListener(Http11Protocol proto, ThreadPool control) {
        }

        public void threadStart(ThreadPool tp, Thread t) {
        }

        public void threadEnd(ThreadPool tp, Thread t) {
            ObjectName oname;
            ThreadWithAttributes ta = (ThreadWithAttributes)t;
            Object[] tpData = ta.getThreadData(tp);
            if (tpData == null) {
                return;
            }
            if (tpData[1] instanceof Object[]) {
                tpData = (Object[])tpData[1];
            }
            if ((oname = (ObjectName)tpData[2]) == null) {
                return;
            }
            Registry.getRegistry().unregisterComponent(oname);
            Http11Processor processor = (Http11Processor)tpData[1];
            RequestInfo rp = processor.getRequest().getRequestProcessor();
            rp.setGlobalProcessor(null);
        }
    }
}

