/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.coyote.http11.filters.ChunkedInputFilter;
import org.apache.coyote.http11.filters.ChunkedOutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.coyote.http11.filters.IdentityInputFilter;
import org.apache.coyote.http11.filters.IdentityOutputFilter;
import org.apache.coyote.http11.filters.VoidInputFilter;
import org.apache.coyote.http11.filters.VoidOutputFilter;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.threads.ThreadPool;
import org.apache.tomcat.util.threads.ThreadWithAttributes;

public class Http11Processor
implements Processor,
ActionHook {
    protected Adapter adapter = null;
    protected Request request = null;
    protected Response response = null;
    protected InternalInputBuffer inputBuffer = null;
    protected InternalOutputBuffer outputBuffer = null;
    protected boolean started = false;
    protected boolean error = false;
    protected boolean keepAlive = true;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected String[] restrictedUserAgents = null;
    protected static Log log = LogFactory.getLog(class$org$apache$coyote$http11$Http11Processor == null ? (class$org$apache$coyote$http11$Http11Processor = Http11Processor.class$("org.apache.coyote.http11.Http11Processor")) : class$org$apache$coyote$http11$Http11Processor);
    protected int maxKeepAliveRequests = -1;
    protected SSLSupport sslSupport;
    protected Socket socket;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String localName = null;
    protected int localPort = -1;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected int timeout = 300000;
    protected boolean disableUploadTimeout = false;
    protected int compressionLevel = 0;
    protected int compressionMinSize = 2048;
    protected int maxPostSize = 0x200000;
    protected String[] noCompressionUserAgents = null;
    protected String[] compressableMimeTypes = new String[]{"text/html", "text/xml", "text/plain"};
    protected char[] hostNameC = new char[0];
    protected ThreadPool threadPool;
    private static final String USE_KEEP_ALIVE = "com.sun.enterprise.web.connector.coyote.useKeepAliveAlgorithm";
    private boolean useKeepAliveAlgorithm = true;
    private int requestBufferSize = 4096;
    static /* synthetic */ Class class$org$apache$coyote$http11$Http11Processor;

    public Http11Processor() {
        this(49152);
    }

    public Http11Processor(int headerBufferSize) {
        this.request = new Request();
        this.inputBuffer = new InternalInputBuffer(this.request, this.requestBufferSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.response = new Response();
        this.response.setHook(this);
        this.outputBuffer = new InternalOutputBuffer(this.response, headerBufferSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters();
        if (System.getProperty(USE_KEEP_ALIVE) != null) {
            this.useKeepAliveAlgorithm = Boolean.valueOf(System.getProperty(USE_KEEP_ALIVE));
            if (!this.useKeepAliveAlgorithm) {
                log.warn("Keep Alive algorith will no be used");
            }
        }
    }

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    public void setCompression(String compression) {
        if (compression.equals("on")) {
            this.compressionLevel = 1;
        } else if (compression.equals("force")) {
            this.compressionLevel = 2;
        } else if (compression.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.compressionMinSize = Integer.parseInt(compression);
                this.compressionLevel = 1;
            }
            catch (Exception e) {
                this.compressionLevel = 0;
            }
        }
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void addNoCompressionUserAgent(String userAgent) {
        this.addStringArray(this.noCompressionUserAgents, userAgent);
    }

    public void setNoCompressionUserAgents(String[] noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public String[] findNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void addCompressableMimeType(String mimeType) {
        this.addStringArray(this.compressableMimeTypes, mimeType);
    }

    public void setCompressableMimeType(String[] compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    public String[] findCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    protected void addFilter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            if (obj instanceof InputFilter) {
                this.inputBuffer.addFilter((InputFilter)obj);
            } else if (obj instanceof OutputFilter) {
                this.outputBuffer.addFilter((OutputFilter)obj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addStringArray(String[] sArray, String value) {
        if (sArray == null) {
            sArray = new String[]{};
        }
        String[] results = new String[sArray.length + 1];
        for (int i = 0; i < sArray.length; ++i) {
            results[i] = sArray[i];
        }
        results[sArray.length] = value;
        sArray = results;
    }

    private boolean inStringArray(String[] sArray, String value) {
        for (int i = 0; i < sArray.length; ++i) {
            if (!sArray[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public void addRestrictedUserAgent(String userAgent) {
        this.addStringArray(this.restrictedUserAgents, userAgent);
    }

    public void setRestrictedUserAgents(String[] restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public String[] findRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxPostSize(int mps) {
        this.maxPostSize = mps;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setSSLSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    public void setSocket(Socket socket) throws IOException {
        this.socket = socket;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Request getRequest() {
        return this.request;
    }

    public void process(InputStream input, OutputStream output) throws IOException {
        ThreadWithAttributes thrA = (ThreadWithAttributes)Thread.currentThread();
        RequestInfo rp = this.request.getRequestProcessor();
        thrA.setCurrentStage(this.threadPool, "parsing http request");
        rp.setStage(1);
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localAddr = null;
        this.remotePort = -1;
        this.inputBuffer.setInputStream(input);
        this.outputBuffer.setOutputStream(output);
        this.error = false;
        this.keepAlive = true;
        int keepAliveLeft = this.maxKeepAliveRequests;
        int soTimeout = this.socket.getSoTimeout();
        if (this.useKeepAliveAlgorithm) {
            float threadRatio = (float)this.threadPool.getCurrentThreadsBusy() / (float)this.threadPool.getMaxThreads();
            if ((double)threadRatio > 0.33 && (double)threadRatio <= 0.66) {
                soTimeout /= 2;
            } else if ((double)threadRatio > 0.66) {
                soTimeout /= 5;
                keepAliveLeft = 1;
            }
        }
        boolean keptAlive = false;
        while (this.started && !this.error && this.keepAlive) {
            try {
                if (!this.disableUploadTimeout && keptAlive && soTimeout > 0) {
                    this.socket.setSoTimeout(soTimeout);
                }
                this.inputBuffer.parseRequestLine();
                this.request.setStartTime(System.currentTimeMillis());
                thrA.setParam(this.threadPool, this.request.requestURI());
                keptAlive = true;
                if (!this.disableUploadTimeout) {
                    this.socket.setSoTimeout(this.timeout);
                }
                this.inputBuffer.parseHeaders();
            }
            catch (IOException e) {
                this.error = true;
                break;
            }
            catch (Exception e) {
                log.debug("Error parsing HTTP request", e);
                this.response.setStatus(400);
                this.error = true;
            }
            thrA.setCurrentStage(this.threadPool, "prepareRequest");
            rp.setStage(2);
            try {
                this.prepareRequest();
            }
            catch (Throwable t) {
                log.debug("Error preparing request", t);
                this.response.setStatus(400);
                this.error = true;
            }
            if (this.useKeepAliveAlgorithm) {
                if (this.maxKeepAliveRequests > 0 && --keepAliveLeft == 0) {
                    this.keepAlive = false;
                }
            } else {
                this.keepAlive = false;
            }
            if (!this.error) {
                try {
                    thrA.setCurrentStage(this.threadPool, "service");
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                    if (this.keepAlive && !this.error) {
                        this.error = this.response.getErrorException() != null || this.statusDropsConnection(this.response.getStatus());
                    }
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    log.error("Error processing request", t);
                    this.response.setStatus(500);
                    this.error = true;
                }
            }
            try {
                thrA.setCurrentStage(this.threadPool, "endRequestIB");
                rp.setStage(4);
                this.inputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
            catch (Throwable t) {
                log.error("Error finishing request", t);
                this.response.setStatus(500);
                this.error = true;
            }
            try {
                thrA.setCurrentStage(this.threadPool, "endRequestOB");
                rp.setStage(5);
                this.outputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
            catch (Throwable t) {
                log.error("Error finishing response", t);
                this.error = true;
            }
            thrA.setCurrentStage(this.threadPool, "ended");
            rp.setStage(6);
            this.inputBuffer.nextRequest();
            this.outputBuffer.nextRequest();
        }
        rp.setStage(7);
        this.inputBuffer.recycle();
        this.outputBuffer.recycle();
        this.sslSupport = null;
    }

    public void action(ActionCode actionCode, Object param) {
        block52: {
            if (actionCode == ActionCode.ACTION_COMMIT) {
                if (this.response.isCommitted()) {
                    return;
                }
                this.prepareResponse();
                try {
                    this.outputBuffer.commit();
                }
                catch (IOException e) {
                    this.error = true;
                }
            } else if (actionCode == ActionCode.ACTION_ACK) {
                if (this.response.isCommitted()) {
                    return;
                }
                MessageBytes expectMB = this.request.getMimeHeaders().getValue("expect");
                if (expectMB != null && expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
                    try {
                        this.outputBuffer.sendAck();
                    }
                    catch (IOException e) {
                        this.error = true;
                        this.response.setErrorException(e);
                    }
                }
            } else if (actionCode == ActionCode.ACTION_CLOSE) {
                try {
                    this.outputBuffer.endRequest();
                }
                catch (IOException e) {
                    this.error = true;
                }
            } else if (actionCode == ActionCode.ACTION_RESET) {
                this.outputBuffer.reset();
            } else if (actionCode != ActionCode.ACTION_CUSTOM) {
                if (actionCode == ActionCode.ACTION_START) {
                    this.started = true;
                } else if (actionCode == ActionCode.ACTION_STOP) {
                    this.started = false;
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
                    try {
                        if (this.sslSupport == null) break block52;
                        Object sslO = this.sslSupport.getCipherSuite();
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                        }
                        if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                        if ((sslO = this.sslSupport.getKeySize()) != null) {
                            this.request.setAttribute("javax.servlet.request.key_size", sslO);
                        }
                        if ((sslO = this.sslSupport.getSessionId()) != null) {
                            this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception getting SSL attributes ", e);
                    }
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE) {
                    if (this.remoteAddr == null && this.socket != null) {
                        InetAddress inetAddr = this.socket.getInetAddress();
                        this.remoteAddr = inetAddr.getHostAddress();
                        this.request.remoteAddr().setString(this.remoteAddr);
                    }
                } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.localName == null && this.socket != null && (inetAddr = this.socket.getLocalAddress()) != null) {
                        this.localName = inetAddr.getHostName();
                    }
                    this.request.localName().setString(this.localName);
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.remoteHost == null && this.socket != null && (inetAddr = this.socket.getInetAddress()) != null) {
                        this.remoteHost = inetAddr.getHostName();
                    }
                    this.request.remoteHost().setString(this.remoteHost);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE) {
                    if (this.localAddr == null) {
                        this.localAddr = this.socket.getLocalAddress().getHostAddress();
                    }
                    this.request.localAddr().setString(this.localAddr);
                } else if (actionCode == ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE) {
                    if (this.remotePort == -1 && this.socket != null) {
                        this.remotePort = this.socket.getPort();
                    }
                    this.request.setRemotePort(this.remotePort);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE) {
                    if (this.localPort == -1 && this.socket != null) {
                        this.localPort = this.socket.getLocalPort();
                    }
                    this.request.setLocalPort(this.localPort);
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_CERTIFICATE && this.sslSupport != null) {
                    InputFilter[] inputFilters = this.inputBuffer.getFilters();
                    ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxPostSize);
                    this.inputBuffer.addActiveFilter(inputFilters[3]);
                    try {
                        Object[] sslO = this.sslSupport.getPeerCertificateChain(true);
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception getting SSL Cert", e);
                    }
                }
            }
        }
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected void prepareRequest() {
        ByteChunk uriBC;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        if (this.sslSupport != null) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.error = true;
            this.response.setStatus(505);
        }
        MessageBytes methodMB = this.request.method();
        if (methodMB.equals("GET")) {
            methodMB.setString("GET");
        } else if (methodMB.equals("POST")) {
            methodMB.setString("POST");
        }
        MessageBytes connectionValueMB = this.request.getMimeHeaders().getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
            } else if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
            }
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive)) {
            MessageBytes userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent");
            String userAgentValue = userAgentValueMB.toString();
            for (int i = 0; i < this.restrictedUserAgents.length; ++i) {
                if (!this.restrictedUserAgents[i].equals(userAgentValue)) continue;
                this.http11 = false;
                this.keepAlive = false;
            }
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = this.request.getMimeHeaders().setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        long contentLength = this.request.getContentLengthLong();
        if (contentLength >= 0L) {
            this.inputBuffer.addActiveFilter(inputFilters[0]);
            this.contentDelimitation = true;
        }
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = this.request.getMimeHeaders().getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos).toLowerCase().trim();
                if (!this.addInputFilter(inputFilters, encodingName)) {
                    this.error = true;
                    this.response.setStatus(501);
                }
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos).toLowerCase().trim();
            if (!this.addInputFilter(inputFilters, encodingName)) {
                this.error = true;
                this.response.setStatus(501);
            }
        }
        MessageBytes valueMB = this.request.getMimeHeaders().getValue("host");
        if (this.http11 && valueMB == null) {
            this.error = true;
            this.response.setStatus(400);
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation && this.keepAlive) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
        if (!this.contentDelimitation) {
            this.keepAlive = false;
        }
    }

    public void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(this.socket.getLocalPort());
            InetAddress localAddress = this.socket.getLocalAddress();
            this.request.setLocalHost(localAddress.getHostName());
            this.request.serverName().setString(localAddress.getHostName());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (this.sslSupport == null) {
                this.request.setServerPort(80);
            } else {
                this.request.setServerPort(443);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB[i + valueS]];
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    private boolean isCompressable() {
        MessageBytes userAgentValueMB;
        String userAgentValue;
        if (!this.http11) {
            return false;
        }
        MessageBytes acceptEncodingMB = this.request.getMimeHeaders().getValue("accept-encoding");
        if (acceptEncodingMB == null || acceptEncodingMB.indexOf("gzip") == -1) {
            return false;
        }
        MessageBytes contentEncodingMB = this.response.getMimeHeaders().getValue("Content-Encoding");
        if (contentEncodingMB != null && contentEncodingMB.indexOf("gzip") != -1) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        if (this.noCompressionUserAgents != null && this.inStringArray(this.noCompressionUserAgents, userAgentValue = (userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent")).toString())) {
            return false;
        }
        int contentLength = this.response.getContentLength();
        if ((contentLength == -1 || contentLength > this.compressionMinSize) && this.compressableMimeTypes != null) {
            return this.inStringArray(this.compressableMimeTypes, this.response.getContentType());
        }
        return false;
    }

    protected void prepareResponse() {
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.outputBuffer.getFilters();
        if (this.http09) {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        boolean useCompression = false;
        if (entityBody && this.compressionLevel > 0 && (useCompression = this.isCompressable())) {
            this.response.setContentLength(-1);
        }
        MimeHeaders headers = this.response.getMimeHeaders();
        if (!entityBody) {
            this.response.setContentLength(-1);
        } else {
            String contentLanguage;
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = this.response.getContentLanguage()) != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        int contentLength = this.response.getContentLength();
        if (contentLength != -1) {
            this.response.getMimeHeaders().setValue("Content-Length").setInt(contentLength);
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else if (entityBody && this.http11) {
            this.outputBuffer.addActiveFilter(outputFilters[1]);
            this.contentDelimitation = true;
            this.response.addHeader("Transfer-Encoding", "chunked");
        }
        if (useCompression) {
            this.outputBuffer.addActiveFilter(outputFilters[3]);
            this.response.setHeader("Content-Encoding", "gzip");
            this.response.setHeader("Vary", "Accept-Encoding");
        }
        if (!this.response.containsHeader("Date")) {
            this.response.addHeader("Date", FastHttpDateFormat.getCurrentDate());
        }
        this.response.addHeader("Server", Constants.SERVER);
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        boolean bl = this.keepAlive = this.keepAlive && !this.statusDropsConnection(statusCode);
        if (!this.keepAlive) {
            this.response.addHeader("Connection", "close");
        } else if (!this.http11) {
            this.response.addHeader("Connection", "Keep-Alive");
        }
        this.outputBuffer.sendStatus();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            this.outputBuffer.sendHeader(headers.getName(i), headers.getValue(i));
        }
        this.outputBuffer.endHeaders();
    }

    protected void initializeFilters() {
        this.inputBuffer.addFilter(new IdentityInputFilter());
        this.outputBuffer.addFilter(new IdentityOutputFilter());
        this.inputBuffer.addFilter(new ChunkedInputFilter());
        this.outputBuffer.addFilter(new ChunkedOutputFilter());
        this.inputBuffer.addFilter(new VoidInputFilter());
        this.outputBuffer.addFilter(new VoidOutputFilter());
        this.inputBuffer.addFilter(new BufferedInputFilter());
        this.outputBuffer.addFilter(new GzipOutputFilter());
    }

    protected boolean addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!encodingName.equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.inputBuffer.addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                for (int i = 2; i < inputFilters.length; ++i) {
                    if (!inputFilters[i].getEncodingName().toString().equals(encodingName)) continue;
                    this.inputBuffer.addActiveFilter(inputFilters[i]);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower(buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    protected boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 500 || status == 503 || status == 501;
    }

    public void setBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getBufferSize() {
        return this.requestBufferSize;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

