/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public abstract class RequestFilterValve
extends ValveBase {
    protected String allow = null;
    protected RE[] allows = new RE[0];
    protected RE[] denies = new RE[0];
    protected String deny = null;
    private static final String info = "org.apache.catalina.valves.RequestFilterValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public String getAllow() {
        return this.allow;
    }

    public void setAllow(String allow) {
        this.allow = allow;
        this.allows = this.precalculate(allow);
    }

    public String getDeny() {
        return this.deny;
    }

    public void setDeny(String deny) {
        this.deny = deny;
        this.denies = this.precalculate(deny);
    }

    public String getInfo() {
        return info;
    }

    public abstract int invoke(Request var1, Response var2) throws IOException, ServletException;

    protected RE[] precalculate(String list) {
        int comma;
        if (list == null) {
            return new RE[0];
        }
        if ((list = list.trim()).length() < 1) {
            return new RE[0];
        }
        list = list + ",";
        ArrayList<RE> reList = new ArrayList<RE>();
        while (list.length() > 0 && (comma = list.indexOf(44)) >= 0) {
            String pattern = list.substring(0, comma).trim();
            try {
                reList.add(new RE(pattern));
            }
            catch (RESyntaxException e) {
                IllegalArgumentException iae = new IllegalArgumentException(sm.getString("requestFilterValve.syntax", pattern));
                iae.initCause(e);
                throw iae;
            }
            list = list.substring(comma + 1);
        }
        RE[] reArray = new RE[reList.size()];
        return reList.toArray(reArray);
    }

    protected int process(String property, Request request, Response response) throws IOException, ServletException {
        int i;
        for (i = 0; i < this.denies.length; ++i) {
            ServletResponse sres;
            if (!this.denies[i].match(property) || !((sres = response.getResponse()) instanceof HttpServletResponse)) continue;
            HttpServletResponse hres = (HttpServletResponse)sres;
            hres.sendError(403);
            return 2;
        }
        for (i = 0; i < this.allows.length; ++i) {
            if (!this.allows[i].match(property)) continue;
            return 1;
        }
        if (this.denies.length > 0 && this.allows.length == 0) {
            return 1;
        }
        ServletResponse sres = response.getResponse();
        if (sres instanceof HttpServletResponse) {
            HttpServletResponse hres = (HttpServletResponse)sres;
            hres.sendError(403);
            return 2;
        }
        return 2;
    }
}

