/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.catalina.loader.StandardClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClassLoaderFactory {
    private static Log log = LogFactory.getLog(class$org$apache$catalina$startup$ClassLoaderFactory == null ? (class$org$apache$catalina$startup$ClassLoaderFactory = ClassLoaderFactory.class$("org.apache.catalina.startup.ClassLoaderFactory")) : class$org$apache$catalina$startup$ClassLoaderFactory);
    private static int debug = 0;
    static /* synthetic */ Class class$org$apache$catalina$startup$ClassLoaderFactory;

    public static int getDebug() {
        return debug;
    }

    public static void setDebug(int newDebug) {
        debug = newDebug;
    }

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, ClassLoader parent) throws Exception {
        return ClassLoaderFactory.createClassLoader(unpacked, packed, null, parent);
    }

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, URL[] urls, ClassLoader parent) throws Exception {
        int i;
        if (log.isDebugEnabled()) {
            log.debug("Creating new class loader");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (unpacked != null) {
            for (i = 0; i < unpacked.length; ++i) {
                File file = unpacked[i];
                if (!file.exists() || !file.canRead()) continue;
                if (log.isDebugEnabled()) {
                    log.debug("  Including directory or JAR " + file.getAbsolutePath());
                }
                URL url = new URL("file", null, file.getCanonicalPath() + File.separator);
                list.add(url.toString());
            }
        }
        if (packed != null) {
            for (i = 0; i < packed.length; ++i) {
                File directory = packed[i];
                if (!directory.isDirectory() || !directory.exists() || !directory.canRead()) continue;
                String[] filenames = directory.list();
                for (int j = 0; j < filenames.length; ++j) {
                    String filename = filenames[j].toLowerCase();
                    if (!filename.endsWith(".jar")) continue;
                    File file = new File(directory, filenames[j]);
                    if (log.isDebugEnabled()) {
                        log.debug("  Including jar file " + file.getAbsolutePath());
                    }
                    URL url = new URL("file", null, file.getCanonicalPath());
                    list.add(url.toString());
                }
            }
        }
        if (urls != null) {
            for (i = 0; i < urls.length; ++i) {
                list.add(urls[i].toString());
            }
        }
        String[] array = list.toArray(new String[list.size()]);
        StandardClassLoader classLoader = null;
        classLoader = parent == null ? new StandardClassLoader(array) : new StandardClassLoader(array, parent);
        classLoader.setDelegate(true);
        return classLoader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

