/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Service;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardDefaultContext;
import org.apache.catalina.core.StandardEngineValve;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.realm.JAASRealm;
import org.apache.catalina.util.ServerInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.modules.MbeansSource;

public class StandardEngine
extends ContainerBase
implements Engine {
    private static Log log = LogFactory.getLog(class$org$apache$catalina$core$StandardEngine == null ? (class$org$apache$catalina$core$StandardEngine = StandardEngine.class$("org.apache.catalina.core.StandardEngine")) : class$org$apache$catalina$core$StandardEngine);
    private String defaultHost = null;
    private static final String info = "org.apache.catalina.core.StandardEngine/1.0";
    private Service service = null;
    private String baseDir = null;
    private String mbeansFile = null;
    private List mbeans;
    private DefaultContext defaultContext;
    private String jvmRouteId;
    private boolean initialized = false;
    static /* synthetic */ Class class$org$apache$catalina$core$StandardEngine;

    public StandardEngine() {
        this.pipeline.setBasic(new StandardEngineValve());
        try {
            this.setJvmRoute(System.getProperty("jvmRoute"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.backgroundProcessorDelay = 10;
    }

    public Realm getRealm() {
        Realm configured = super.getRealm();
        if (configured == null) {
            configured = new JAASRealm();
            this.setRealm(configured);
        }
        return configured;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultHost(String host) {
        String oldDefaultHost = this.defaultHost;
        this.defaultHost = host == null ? null : host;
        this.support.firePropertyChange("defaultHost", oldDefaultHost, this.defaultHost);
    }

    public void setName(String name) {
        if (this.domain != null) {
            super.setName(this.domain);
            return;
        }
        this.domain = name;
        super.setName(name);
    }

    public void setJvmRoute(String routeId) {
        this.jvmRouteId = routeId;
    }

    public String getJvmRoute() {
        return this.jvmRouteId;
    }

    public void addDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public String getMbeansFile() {
        return this.mbeansFile;
    }

    public void setMbeansFile(String mbeansFile) {
        this.mbeansFile = mbeansFile;
    }

    public String getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.base");
        }
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.home");
        }
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void installDefaultContext(Context context) {
        if (this.defaultContext != null && this.defaultContext instanceof StandardDefaultContext) {
            ((StandardDefaultContext)this.defaultContext).installDefaultContext(context);
        }
    }

    public void importDefaultContext(Context context) {
        if (this.defaultContext != null) {
            this.defaultContext.importDefaultContext(context);
        }
    }

    public void addChild(Container child) {
        if (!(child instanceof Host)) {
            throw new IllegalArgumentException(sm.getString("standardEngine.notHost"));
        }
        super.addChild(child);
    }

    public String getInfo() {
        return info;
    }

    public void setParent(Container container) {
        throw new IllegalArgumentException(sm.getString("standardEngine.notParent"));
    }

    public void init() {
        String defaultMBeansFile;
        File f;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.oname == null) {
            try {
                if (this.domain == null) {
                    this.domain = this.getName();
                }
                log.debug("Register " + this.domain);
                this.controller = this.oname = new ObjectName(this.domain + ":type=Engine");
                Registry.getRegistry().registerComponent((Object)this, this.oname, null);
            }
            catch (Throwable t) {
                log.info("Error registering ", t);
            }
        }
        if (this.mbeansFile == null && (f = new File(defaultMBeansFile = this.getBaseDir() + "/conf/tomcat5-mbeans.xml")).exists()) {
            this.mbeansFile = f.getAbsolutePath();
        }
        if (this.mbeansFile != null) {
            this.readEngineMbeans();
        }
        if (this.mbeans != null) {
            try {
                Registry.getRegistry().invoke(this.mbeans, "init", false);
            }
            catch (Exception e) {
                log.error("Error in init() for " + this.mbeansFile, e);
            }
        }
        if (this.service == null) {
            try {
                this.service = new StandardService();
                this.service.setContainer(this);
                this.service.initialize();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void destroy() throws LifecycleException {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        ((StandardService)this.service).destroy();
        if (this.mbeans != null) {
            try {
                Registry.getRegistry().invoke(this.mbeans, "destroy", false);
            }
            catch (Exception e) {
                log.error("Error in destroy() for " + this.mbeansFile, e);
            }
        }
        if (this.mbeans != null) {
            try {
                for (int i = 0; i < this.mbeans.size(); ++i) {
                    Registry.getRegistry().unregisterComponent((ObjectName)this.mbeans.get(i));
                }
            }
            catch (Exception e) {
                log.error("Error in destroy() for " + this.mbeansFile, e);
            }
        }
        Registry.getRegistry().resetMetadata();
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        log.info("Starting Servlet Engine: " + ServerInfo.getServerInfo());
        if (this.mbeans != null) {
            try {
                Registry.getRegistry().invoke(this.mbeans, "start", false);
            }
            catch (Exception e) {
                log.error("Error in start() for " + this.mbeansFile, e);
            }
        }
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.mbeans != null) {
            try {
                Registry.getRegistry().invoke(this.mbeans, "stop", false);
            }
            catch (Exception e) {
                log.error("Error in stop() for " + this.mbeansFile, e);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardEngine[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        super.preRegister(server, name);
        this.setName(name.getDomain());
        return name;
    }

    public ObjectName getParentName() throws MalformedObjectNameException {
        if (this.getService() == null) {
            return null;
        }
        String name = this.getService().getName();
        ObjectName serviceName = new ObjectName(this.domain + ":type=Service,serviceName=" + name);
        return serviceName;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Create ObjectName " + domain + " " + parent);
        }
        return new ObjectName(domain + ":type=Engine");
    }

    private void readEngineMbeans() {
        try {
            MbeansSource mbeansMB = new MbeansSource();
            File mbeansF = new File(this.mbeansFile);
            mbeansMB.setSource(mbeansF);
            Registry.getRegistry().registerComponent((Object)mbeansMB, this.domain + ":type=MbeansFile", null);
            mbeansMB.load();
            mbeansMB.init();
            mbeansMB.setRegistry(Registry.getRegistry());
            this.mbeans = mbeansMB.getMBeans();
        }
        catch (Throwable t) {
            log.error("Error loading " + this.mbeansFile, t);
        }
    }

    public String getDomain() {
        if (this.domain != null) {
            return this.domain;
        }
        return this.getName();
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

