/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Enumerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.log.SystemLogHandler;

final class ApplicationFilterConfig
implements FilterConfig,
Serializable {
    private static Log log = LogFactory.getLog(class$org$apache$catalina$core$ApplicationFilterConfig == null ? (class$org$apache$catalina$core$ApplicationFilterConfig = ApplicationFilterConfig.class$("org.apache.catalina.core.ApplicationFilterConfig")) : class$org$apache$catalina$core$ApplicationFilterConfig);
    private Context context = null;
    private transient Filter filter = null;
    private FilterDef filterDef = null;
    static /* synthetic */ Class class$org$apache$catalina$core$ApplicationFilterConfig;

    public ApplicationFilterConfig(Context context, FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.context = context;
        this.setFilterDef(filterDef);
    }

    public String getFilterName() {
        return this.filterDef.getFilterName();
    }

    public String getInitParameter(String name) {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return null;
        }
        return (String)map.get(name);
    }

    public Enumeration getInitParameterNames() {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return new Enumerator(new ArrayList());
        }
        return new Enumerator(map.keySet());
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ApplicationFilterConfig[");
        sb.append("name=");
        sb.append(this.filterDef.getFilterName());
        sb.append(", filterClass=");
        sb.append(this.filterDef.getFilterClass());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Filter getFilter() throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        block6: {
            block5: {
                if (this.filter != null) {
                    return this.filter;
                }
                String filterClass = this.filterDef.getFilterClass();
                ClassLoader classLoader = null;
                classLoader = filterClass.startsWith("org.apache.catalina.") ? this.getClass().getClassLoader() : this.context.getLoader().getClassLoader();
                ClassLoader oldCtxClassLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = classLoader.loadClass(filterClass);
                this.filter = (Filter)clazz.newInstance();
                if (!(this.context instanceof StandardContext) || !((StandardContext)this.context).getSwallowOutput()) break block5;
                try {
                    SystemLogHandler.startCapture();
                    this.filter.init((FilterConfig)this);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    String log = SystemLogHandler.stopCapture();
                    if (log != null && log.length() > 0) {
                        this.getServletContext().log(log);
                    }
                    throw throwable;
                }
                String log = SystemLogHandler.stopCapture();
                if (log != null && log.length() > 0) {
                    this.getServletContext().log(log);
                }
                break block6;
            }
            this.filter.init((FilterConfig)this);
        }
        return this.filter;
    }

    FilterDef getFilterDef() {
        return this.filterDef;
    }

    void release() {
        if (this.filter != null) {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    SecurityUtil.doAsPrivilege("destroy", this.filter);
                    SecurityUtil.remove(this.filter);
                }
                catch (Exception ex) {
                    log.error("ApplicationFilterConfig.doAsPrivilege", ex);
                }
            } else {
                this.filter.destroy();
            }
        }
        this.filter = null;
    }

    void setFilterDef(FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.filterDef = filterDef;
        if (filterDef == null) {
            if (this.filter != null) {
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    try {
                        SecurityUtil.doAsPrivilege("destroy", this.filter);
                        SecurityUtil.remove(this.filter);
                    }
                    catch (Exception ex) {
                        log.error("ApplicationFilterConfig.doAsPrivilege", ex);
                    }
                } else {
                    this.filter.destroy();
                }
            }
            this.filter = null;
        } else {
            Filter filter = this.getFilter();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

