/*
 * Decompiled with CFR 0.152.
 */
package javax.security.sasl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslServerFactory;

class SaslFactoryEnumeration
implements Enumeration {
    static boolean _isJava2 = false;
    static final boolean _debug;
    private List _factories = new ArrayList();
    private int _index = 0;
    private String _interfaceName;

    SaslFactoryEnumeration(String className, String interfaceName) {
        this._interfaceName = interfaceName;
        Provider p = Security.getProvider(className);
        if (p != null) {
            if (_debug) {
                System.out.println("Provider: " + p);
            }
            Object[] facNames = p.values().toArray();
            int i = 0;
            while (i < facNames.length) {
                this._factories.add(facNames[i]);
                ++i;
            }
        } else if (_debug) {
            System.out.println("No provider for: " + className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasMoreElements() {
        List list = this._factories;
        synchronized (list) {
            if (_debug) {
                System.out.println("SaslFactoryEnumeration.hasMoreElements: index is " + this._index + "; size is " + this._factories.size());
            }
            while (this._index < this._factories.size()) {
                int dup;
                Object obj = this._factories.get(this._index);
                if (obj instanceof String) {
                    dup = this.findDuplicate((String)obj, this._index);
                    if (dup >= 0) {
                        this._factories.remove(this._index);
                        continue;
                    }
                    try {
                        obj = Class.forName((String)obj);
                    }
                    catch (Exception e) {
                        if (_debug) {
                            System.out.println("SaslFactoryEnumeration.hasMoreElements: could not instantiate class " + obj);
                        }
                        this._factories.remove(this._index);
                        continue;
                    }
                }
                if (obj instanceof Class) {
                    Object o = obj;
                    int dup2 = this.findDuplicate(((Class)obj).getName(), this._index);
                    if (dup2 >= 0) {
                        this._factories.remove(this._index);
                        continue;
                    }
                    try {
                        obj = ((Class)obj).newInstance();
                        this._factories.set(this._index, obj);
                        if (!_debug) return true;
                        System.out.println("SaslFactoryEnumeration.hasMoreElements: instantiated object " + obj + "; returning true");
                        return true;
                    }
                    catch (Exception e) {
                        if (_debug) {
                            System.out.println("SaslFactoryEnumeration.hasMoreElements: could not instantiate object " + o);
                        }
                        this._factories.remove(this._index);
                        continue;
                    }
                }
                if (!(obj instanceof SaslClientFactory) && !(obj instanceof SaslServerFactory)) {
                    throw new IllegalArgumentException("Expecting " + this._interfaceName + "; found " + obj.getClass().getName());
                }
                if (_debug) {
                    System.out.println("SaslFactoryEnumeration.hasMoreElements: object is " + obj);
                }
                if ((dup = this.findDuplicate(obj.getClass().getName(), this._index)) >= 0) {
                    this._factories.remove(this._index);
                    continue;
                }
                if (!_debug) return true;
                System.out.println("SaslFactoryEnumeration.hasMoreElements: returning true ");
                return true;
            }
        }
        if (!_debug) return false;
        System.out.println("SaslFactoryEnumeration.hasMoreElements: returning false");
        return false;
    }

    int findDuplicate(String name, int ind) {
        int i = ind - 1;
        while (i >= 0) {
            String knownName = this._factories.get(i).getClass().getName();
            if (name.equals(knownName)) {
                if (_debug) {
                    System.out.println("SaslFactoryEnumeration.hasMoreElements: duplicate " + knownName + "; removing " + "index " + ind);
                }
                return ind;
            }
            --i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object nextElement() {
        Object obj = null;
        List list = this._factories;
        synchronized (list) {
            this.hasMoreElements();
            obj = this._factories.get(this._index++);
            if (_debug) {
                System.out.println("SaslFactoryEnumeration.nextElement: returning factory " + obj.getClass().getName() + " at index " + (this._index - 1));
            }
        }
        return obj;
    }

    static String getSystemProperty(final String propName) {
        if (_isJava2) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return System.getProperty(propName);
                    }
                    catch (SecurityException e) {
                        return null;
                    }
                }
            });
        }
        return System.getProperty(propName);
    }

    static {
        try {
            Class.forName("java.security.PrivilegedAction");
            _isJava2 = true;
        }
        catch (Exception e) {
            _isJava2 = false;
        }
        _debug = SaslFactoryEnumeration.getSystemProperty("javax.security.sasl.SaslFactoryEnumeration.debug") != null;
    }
}

