/*
 * Decompiled with CFR 0.152.
 */
package javax.security.sasl;

import java.util.Enumeration;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslFactoryEnumeration;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public class Sasl {
    private static SaslClientFactory clientFactory = null;
    private static SaslServerFactory serverFactory = null;
    static final String SASL_PKG = "javax.security.sasl";
    public static final String QOP = "javax.security.sasl.qop";
    public static final String STRENGTH = "javax.security.sasl.strength";
    public static final String SERVER_AUTH = "javax.security.sasl.server.authentication";
    public static final String MAX_BUFFER = "javax.security.sasl.maxbuffer";
    public static final String RAW_SEND_SIZE = "javax.security.sasl.rawsendsize";
    static final String SASL_POLICY_PKG = "javax.security.sasl.policy";
    public static final String POLICY_NOPLAINTEXT = "javax.security.sasl.policy.noplaintext";
    public static final String POLICY_NOACTIVE = "javax.security.sasl.policy.noactive";
    public static final String POLICY_NODICTIONARY = "javax.security.sasl.policy.nodictionary";
    public static final String POLICY_NOANONYMOUS = "javax.security.sasl.policy.noanonymous";
    public static final String POLICY_FORWARD_SECRECY = "javax.security.sasl.policy.forward";
    public static final String POLICY_PASS_CREDENTIALS = "javax.security.sasl.policy.credentials";
    public static final String REUSE = "javax.security.sasl.reuse";
    static final String SASL_CLIENT_FACTORY = "javax.security.sasl.SaslClientFactory";
    static final String SASL_SERVER_FACTORY = "javax.security.sasl.SaslServerFactory";

    private Sasl() {
    }

    public static SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map props, CallbackHandler cbh) throws SaslException {
        SaslClient mech = null;
        Enumeration factories = Sasl.getSaslClientFactories();
        while (mech == null && factories.hasMoreElements()) {
            SaslClientFactory factory = (SaslClientFactory)factories.nextElement();
            mech = factory.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
        }
        return mech;
    }

    public static Enumeration getSaslClientFactories() {
        return new SaslFactoryEnumeration("SaslClientFactory", SASL_CLIENT_FACTORY);
    }

    public static SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map props, CallbackHandler cbh) throws SaslException {
        SaslServer mech = null;
        Enumeration factories = Sasl.getSaslServerFactories();
        while (mech == null && factories.hasMoreElements()) {
            SaslServerFactory factory = (SaslServerFactory)factories.nextElement();
            mech = factory.createSaslServer(mechanism, protocol, serverName, props, cbh);
        }
        return mech;
    }

    public static Enumeration getSaslServerFactories() {
        return new SaslFactoryEnumeration("SaslServerFactory", SASL_SERVER_FACTORY);
    }

    static {
        SASL_PKG = SASL_PKG;
        QOP = QOP;
        STRENGTH = STRENGTH;
        SERVER_AUTH = SERVER_AUTH;
        MAX_BUFFER = MAX_BUFFER;
        RAW_SEND_SIZE = RAW_SEND_SIZE;
        SASL_POLICY_PKG = SASL_POLICY_PKG;
        POLICY_NOPLAINTEXT = POLICY_NOPLAINTEXT;
        POLICY_NOACTIVE = POLICY_NOACTIVE;
        POLICY_NODICTIONARY = POLICY_NODICTIONARY;
        POLICY_NOANONYMOUS = POLICY_NOANONYMOUS;
        POLICY_FORWARD_SECRECY = POLICY_FORWARD_SECRECY;
        POLICY_PASS_CREDENTIALS = POLICY_PASS_CREDENTIALS;
        REUSE = REUSE;
        SASL_CLIENT_FACTORY = SASL_CLIENT_FACTORY;
        SASL_SERVER_FACTORY = SASL_SERVER_FACTORY;
    }
}

