/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.reference;

import com.sun.xml.wss.ReferenceElement;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class DirectReference
extends ReferenceElement {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");

    public DirectReference() throws XWSSecurityException {
        try {
            this.setSOAPElement(soapFactory.createElement("Reference", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"));
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0750.soap.exception", new Object[]{"wsse:Reference", e.getMessage()});
            throw new XWSSecurityException(e);
        }
    }

    public DirectReference(SOAPElement element) throws XWSSecurityException {
        this.setSOAPElement(element);
        if (!element.getLocalName().equals("Reference") || !XMLUtil.inWsseNS(element)) {
            log.log(Level.SEVERE, "WSS0751.invalid.direct.reference", "{" + element.getNamespaceURI() + "}" + element.getLocalName());
            throw new XWSSecurityException("Invalid DirectReference passed");
        }
    }

    public String getValueType() {
        String valueType = this.getAttribute("ValueType");
        if (valueType.equals("")) {
            return null;
        }
        return valueType;
    }

    public void setValueType(String valueType) {
        this.setAttribute("ValueType", valueType);
    }

    public String getURI() {
        String uri = this.getAttribute("URI");
        if (uri.equals("")) {
            return null;
        }
        return uri;
    }

    public void setURI(String uri) {
        this.setAttribute("URI", uri);
    }
}

