/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider;

import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.xml.wss.SecureCorrespondent;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.configuration.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.configuration.FilterInfo;
import com.sun.xml.wss.configuration.SecurityConfiguration;
import com.sun.xml.wss.configuration.SecurityConfigurationElement;
import com.sun.xml.wss.configuration.SecurityConfigurationList;
import com.sun.xml.wss.configuration.SecurityConfigurationXmlReader;
import com.sun.xml.wss.configuration.UsernamePasswordOperation;
import com.sun.xml.wss.filter.SetSecurityEnvironmentFilter;
import com.sun.xml.wss.impl.WssProviderSecurityEnvironment;
import com.sun.xml.wss.provider.ConfigurationStates;
import com.sun.xml.wss.provider.ModuleOptions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class WssProviderAuthModule
implements ModuleOptions,
ConfigurationStates {
    protected boolean debug = false;
    protected boolean disableAnnotator = false;
    protected boolean disableRecipient = false;
    protected SecureCorrespondent _annotator = null;
    protected SecureCorrespondent _recipient = null;
    protected SecurityEnvironment securityEnvironment;
    protected DeclarativeSecurityConfiguration _configuration;
    protected static final String ENCRYPT_OPERATION = "EncryptOperation";
    protected static final String SIGN_OPERATION = "SignOperation";
    protected static final String AUTHENTICATE_OPERATION = "UsernamePasswordOperation";
    protected static final String VERIFY_REQUIREMENT = "VerifyRequirement";
    protected static final String DECRYPT_REQUIREMENT = "DecryptRequirement";
    protected static final String AUTHENTICATE_USER_REQUIREMENT = "UsernamePasswordRequirement";
    private CallbackHandler _handler;
    private static final String CONFIG_ELEM_PACKAGE_NAME = "com.sun.xml.wss.configuration.";

    public void initialize(AuthPolicy requestPolicy, AuthPolicy responsePolicy, CallbackHandler handler, Map options, boolean isClientAuthModule) {
        String bg = (String)options.get("debug");
        if (bg != null && bg.equals("true")) {
            this.debug = true;
        }
        String securityConfigurationURL = (String)options.get("security.config");
        try {
            File securityFile = new File(securityConfigurationURL);
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(securityFile));
            this._configuration = SecurityConfigurationXmlReader.createDeclarativeConfiguration(inputStream, true);
            this._handler = handler;
            int request_policy_state = 8;
            int response_policy_state = 8;
            if (requestPolicy == null || (request_policy_state = this.resolveConfigurationState(requestPolicy, true, isClientAuthModule)) == 8) {
                if (isClientAuthModule) {
                    this.disableAnnotator = true;
                } else {
                    this.disableRecipient = true;
                }
            }
            if (responsePolicy == null || (response_policy_state = this.resolveConfigurationState(responsePolicy, false, isClientAuthModule)) == 8) {
                if (isClientAuthModule) {
                    this.disableRecipient = true;
                } else {
                    this.disableAnnotator = true;
                }
            }
            if (isClientAuthModule) {
                this.augmentConfiguration(response_policy_state, true);
                this.augmentConfiguration(request_policy_state, false);
            } else {
                this.augmentConfiguration(response_policy_state, false);
                this.augmentConfiguration(request_policy_state, true);
            }
            this.setSecurityEnvironment(options, this.disableAnnotator, this.disableRecipient);
            SecurityConfiguration securityConfig = this._configuration.createConfiguration();
            if (!this.disableAnnotator) {
                this.configureAnnotatorOrRecipient(securityConfig.getAnnotatorFilters(), true);
            }
            if (!this.disableRecipient) {
                this.configureAnnotatorOrRecipient(securityConfig.getRecipientFilters(), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private void configureAnnotatorOrRecipient(List filterInfos, boolean isAnnotator) throws Exception {
        SecureCorrespondent filterCollection = isAnnotator ? this._annotator : this._recipient;
        Iterator eachFilter = filterInfos.iterator();
        while (eachFilter.hasNext()) {
            FilterInfo filterInfo = (FilterInfo)eachFilter.next();
            filterCollection.addFilter(filterInfo.createFilter());
        }
    }

    private void setSecurityEnvironment(Map options, boolean disableAnnotator, boolean disableRecipient) throws Exception {
        this.securityEnvironment = new WssProviderSecurityEnvironment(this._handler, options);
        SetSecurityEnvironmentFilter secEnvFilter = new SetSecurityEnvironmentFilter(this.securityEnvironment);
        if (!disableAnnotator) {
            this._annotator = new SecureCorrespondent();
            this._annotator.addFilter(secEnvFilter);
        }
        if (!disableRecipient) {
            this._recipient = new SecureCorrespondent();
            this._recipient.addFilter(secEnvFilter);
        }
    }

    public int resolveConfigurationState(AuthPolicy policy, boolean isRequestPolicy, boolean isClientAuthModule) {
        boolean orderForValidation = isClientAuthModule ? !isRequestPolicy : isRequestPolicy;
        boolean sourceAuthRequired = policy.isSourceAuthRequired();
        boolean recipientAuthRequired = policy.isRecipientAuthRequired();
        boolean senderAuthRequired = policy.isSenderAuthRequired();
        boolean contentAuthRequired = policy.isContentAuthRequired();
        boolean beforeContent = policy.isRecipientAuthBeforeContent(orderForValidation);
        int configurationState = 0;
        if (sourceAuthRequired && !recipientAuthRequired) {
            if (senderAuthRequired) {
                configurationState = 2;
            } else if (contentAuthRequired) {
                configurationState = 3;
            }
        } else if (!sourceAuthRequired && recipientAuthRequired) {
            configurationState = 1;
        } else if (sourceAuthRequired && recipientAuthRequired) {
            if (beforeContent) {
                if (senderAuthRequired) {
                    configurationState = 4;
                } else if (contentAuthRequired) {
                    configurationState = 6;
                }
            } else if (senderAuthRequired) {
                configurationState = 5;
            } else if (contentAuthRequired) {
                configurationState = 7;
            }
        } else {
            configurationState = 8;
        }
        if (configurationState == 0) {
            throw new RuntimeException("Invalid Policy State");
        }
        return configurationState;
    }

    private Collection findConfigurationElements(SecurityConfigurationList configElems, String opName) {
        boolean found_elem = false;
        boolean isAuthenticatauthenticate_recipient = opName.equals("com.sun.xml.wss.configuration.UsernamePasswordOperation");
        boolean isRequireAuthenticate = opName.equals("com.sun.xml.wss.configuration.UsernamePasswordRequirement");
        ArrayList<SecurityConfigurationElement> requiredElements = new ArrayList<SecurityConfigurationElement>();
        Iterator it = configElems.iterator();
        while (it.hasNext()) {
            SecurityConfigurationElement configElem = (SecurityConfigurationElement)it.next();
            String currentElement = configElem.getClass().getName();
            if (!currentElement.equals(opName)) continue;
            if (found_elem && (isAuthenticatauthenticate_recipient || isRequireAuthenticate)) {
                throw new RuntimeException("More than one " + opName + " is found in the Config. file");
            }
            if (isAuthenticatauthenticate_recipient) {
                UsernamePasswordOperation up = (UsernamePasswordOperation)configElem;
                NameCallback nameCallback = new NameCallback("Username: ");
                PasswordCallback pwdCallback = new PasswordCallback("Password: ", false);
                Callback[] carray = new Callback[]{nameCallback, pwdCallback};
                try {
                    this._handler.handle(carray);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
                up.setUsername(nameCallback.getName());
                up.setPassword(new String(pwdCallback.getPassword()));
            }
            requiredElements.add(configElem);
            found_elem = true;
        }
        if (!found_elem) {
            throw new RuntimeException("Operation/Requirement (" + opName + ") not specified " + "in the Config. file is required by the policy");
        }
        return requiredElements;
    }

    private void augmentConfiguration(int requiredState, boolean modifyReceiverSettings) {
        String authenticate_source_sender;
        String authenticate_source_content;
        String authenticate_recipient;
        SecurityConfigurationList configElems;
        if (requiredState == 8) {
            return;
        }
        if (modifyReceiverSettings) {
            configElems = this._configuration.receiverSettings();
            authenticate_recipient = "com.sun.xml.wss.configuration.DecryptRequirement";
            authenticate_source_content = "com.sun.xml.wss.configuration.VerifyRequirement";
            authenticate_source_sender = "com.sun.xml.wss.configuration.UsernamePasswordRequirement";
        } else {
            configElems = this._configuration.senderSettings();
            authenticate_recipient = "com.sun.xml.wss.configuration.EncryptOperation";
            authenticate_source_content = "com.sun.xml.wss.configuration.SignOperation";
            authenticate_source_sender = "com.sun.xml.wss.configuration.UsernamePasswordOperation";
        }
        switch (requiredState) {
            case 1: {
                Collection encryptElements = this.findConfigurationElements(configElems, authenticate_recipient);
                configElems.removeAll();
                configElems.appendAll(encryptElements);
                break;
            }
            case 2: {
                Collection authenticateElements = this.findConfigurationElements(configElems, authenticate_source_sender);
                configElems.removeAll();
                configElems.appendAll(authenticateElements);
                break;
            }
            case 3: {
                Collection signElements = this.findConfigurationElements(configElems, authenticate_source_content);
                configElems.removeAll();
                configElems.appendAll(signElements);
                break;
            }
            case 4: {
                Collection encryptElements = this.findConfigurationElements(configElems, authenticate_recipient);
                Collection authenticateElements = this.findConfigurationElements(configElems, authenticate_source_sender);
                configElems.removeAll();
                configElems.appendAll(encryptElements);
                configElems.appendAll(authenticateElements);
                break;
            }
            case 5: {
                Collection authenticateElements = this.findConfigurationElements(configElems, authenticate_source_sender);
                Collection encryptElements = this.findConfigurationElements(configElems, authenticate_recipient);
                configElems.removeAll();
                configElems.appendAll(authenticateElements);
                configElems.appendAll(encryptElements);
                break;
            }
            case 6: {
                Collection encryptElements = this.findConfigurationElements(configElems, authenticate_recipient);
                Collection signElements = this.findConfigurationElements(configElems, authenticate_source_content);
                configElems.removeAll();
                configElems.appendAll(encryptElements);
                configElems.appendAll(signElements);
                break;
            }
            case 7: {
                Collection signElements = this.findConfigurationElements(configElems, authenticate_source_content);
                Collection encryptElements = this.findConfigurationElements(configElems, authenticate_recipient);
                configElems.removeAll();
                configElems.appendAll(signElements);
                configElems.appendAll(encryptElements);
                break;
            }
        }
    }
}

