/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.keyinfo;

import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.KeyInfoStrategy;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityTokenReference;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.reference.X509IssuerSerial;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class X509IssuerSerialStrategy
implements KeyInfoStrategy {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    X509Certificate cert = null;
    String alias = null;
    boolean forSigning;

    public X509IssuerSerialStrategy(String alias, boolean forSigning) {
        this.alias = alias;
        this.forSigning = forSigning;
        this.cert = null;
    }

    public void insertKey(SecurityTokenReference tokenRef, SecurableSoapMessage secureMsg) throws XWSSecurityException {
        X509IssuerSerial x509IssuerSerial = new X509IssuerSerial((Document)secureMsg.getSOAPPart(), this.cert);
        tokenRef.setReference(x509IssuerSerial);
    }

    public void insertKey(KeyInfoHeaderBlock keyInfo, SecurableSoapMessage secureMsg, String x509TokenId) throws XWSSecurityException {
        Document ownerDoc = keyInfo.getOwnerDocument();
        SecurityTokenReference tokenRef = new SecurityTokenReference(ownerDoc);
        X509IssuerSerial x509IssuerSerial = new X509IssuerSerial(ownerDoc, this.cert);
        tokenRef.setReference(x509IssuerSerial);
        keyInfo.addSecurityTokenReference(tokenRef);
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public String getAlias() {
        return this.alias;
    }
}

