/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.keyinfo;

import com.sun.org.apache.xml.security.utils.Base64;
import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.KeyInfoStrategy;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityTokenReference;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.reference.KeyIdentifier;
import com.sun.xml.wss.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.saml.assertion.Assertion;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class KeyIdentifierStrategy
implements KeyInfoStrategy {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    X509Certificate cert = null;
    String alias = null;
    boolean forSigning;
    Assertion samlAssertion = null;

    public KeyIdentifierStrategy(Assertion samlAssertion) {
        this.samlAssertion = samlAssertion;
        this.cert = null;
        this.alias = null;
        this.forSigning = false;
    }

    public KeyIdentifierStrategy(String alias, boolean forSigning) {
        this.alias = alias;
        this.forSigning = forSigning;
        this.samlAssertion = null;
        this.cert = null;
    }

    public void insertKey(SecurityTokenReference tokenRef, SecurableSoapMessage secureMsg) throws XWSSecurityException {
        KeyIdentifier keyIdentifier = this.getKeyIdentifier(secureMsg);
        if (keyIdentifier == null) {
            log.log(Level.SEVERE, "WSS0701.cannot.locate.certificate", this.alias);
            throw new XWSSecurityException("Unable to obtain value for KeyIdentifier Reference");
        }
        tokenRef.setReference(keyIdentifier);
    }

    public void insertKey(KeyInfoHeaderBlock keyInfo, SecurableSoapMessage secureMsg, String x509TokenId) throws XWSSecurityException {
        KeyIdentifier keyIdentifier = this.getKeyIdentifier(secureMsg);
        if (keyIdentifier == null) {
            log.log(Level.SEVERE, "WSS0701.cannot.locate.certificate", this.alias);
            throw new XWSSecurityException("Unable to obtain value for KeyIdentifier Reference");
        }
        Document ownerDoc = keyInfo.getOwnerDocument();
        SecurityTokenReference tokenRef = new SecurityTokenReference(ownerDoc);
        tokenRef.setReference(keyIdentifier);
        keyInfo.addSecurityTokenReference(tokenRef);
    }

    private KeyIdentifier getKeyIdentifier(SecurableSoapMessage secureMsg) throws XWSSecurityException {
        X509SubjectKeyIdentifier keyIdentifier = null;
        if (this.cert != null) {
            byte[] subjectKeyIdentifier = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(this.cert);
            if (subjectKeyIdentifier == null) {
                log.log(Level.SEVERE, "WSS0702.no.subject.keyidentifier", this.alias);
                throw new XWSSecurityException("The found certificate does not contain subject key identifier X509 extension");
            }
            String keyId = Base64.encode(subjectKeyIdentifier);
            keyIdentifier = new X509SubjectKeyIdentifier((Document)secureMsg.getSOAPPart());
            keyIdentifier.setReferenceValue(keyId);
        }
        return keyIdentifier;
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public String getAlias() {
        return this.alias;
    }
}

