/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.keyinfo;

import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.KeyInfoStrategy;
import com.sun.xml.wss.SamlAssertionHeaderBlock;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityTokenReference;
import com.sun.xml.wss.X509SecurityToken;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.reference.DirectReference;
import com.sun.xml.wss.saml.assertion.Assertion;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class DirectReferenceStrategy
implements KeyInfoStrategy {
    X509Certificate cert = null;
    String alias = null;
    boolean forSigning;
    Assertion samlAssertion = null;
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");

    public DirectReferenceStrategy(Assertion samlAssertion) {
        this.samlAssertion = samlAssertion;
        this.cert = null;
        this.alias = null;
        this.forSigning = false;
    }

    public DirectReferenceStrategy(String alias, boolean forSigning) {
        this.alias = alias;
        this.forSigning = forSigning;
        this.samlAssertion = null;
        this.cert = null;
    }

    public void insertKey(SecurityTokenReference tokenRef, SecurableSoapMessage secureMsg) throws XWSSecurityException {
        DirectReference ref = this.getDirectReference(secureMsg, null);
        tokenRef.setReference(ref);
    }

    public void insertKey(KeyInfoHeaderBlock keyInfo, SecurableSoapMessage secureMsg, String x509TokenId) throws XWSSecurityException {
        Document ownerDoc = keyInfo.getOwnerDocument();
        SecurityTokenReference tokenRef = new SecurityTokenReference(ownerDoc);
        DirectReference ref = this.getDirectReference(secureMsg, x509TokenId);
        tokenRef.setReference(ref);
        keyInfo.addSecurityTokenReference(tokenRef);
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public String getAlias() {
        return this.alias;
    }

    private DirectReference getDirectReference(SecurableSoapMessage secureMsg, String x509TokenId) throws XWSSecurityException {
        DirectReference ref = new DirectReference();
        if (this.samlAssertion != null) {
            String uri = "#" + this.samlAssertion.getAssertionID();
            ref.setURI(uri);
            ref.setValueType("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertion-1.1");
            secureMsg.setToken(this.samlAssertion.getAssertionID(), new SamlAssertionHeaderBlock(this.samlAssertion));
        } else {
            if (this.cert == null) {
                log.log(Level.SEVERE, "WSS0185.filterparameter.not.set", new Object[]{"subjectkeyidentifier"});
                throw new XWSSecurityException("No certificate specified and no default found.");
            }
            String wsuId = null;
            wsuId = x509TokenId == null ? secureMsg.generateId() : x509TokenId;
            X509SecurityToken token = new X509SecurityToken((Document)secureMsg.getSOAPPart(), this.cert, wsuId);
            secureMsg.setToken(wsuId, token);
            secureMsg.setFilterParameter("Token", token);
            secureMsg.setFilterParameter("TokenId", wsuId);
            String uri = "#" + wsuId;
            ref.setURI(uri);
            ref.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        }
        return ref;
    }
}

