/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.callback;

import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;

public class CertificateValidationCallback
implements Callback {
    private boolean result = false;
    private CertificateValidator validator;
    private X509Certificate certificate;

    public CertificateValidationCallback(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public boolean getResult() {
        try {
            if (this.validator != null) {
                this.result = this.validator.validate(this.certificate);
            }
        }
        catch (Exception e) {
            return false;
        }
        return this.result;
    }

    public void setValidator(CertificateValidator validator) {
        this.validator = validator;
    }

    public static class CertificateValidationException
    extends Exception {
        public CertificateValidationException(String message) {
            super(message);
        }

        public CertificateValidationException(String message, Throwable cause) {
            super(message, cause);
        }

        public CertificateValidationException(Throwable cause) {
            super(cause);
        }
    }

    public static interface CertificateValidator {
        public boolean validate(X509Certificate var1) throws CertificateValidationException;
    }
}

