/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import com.sun.org.apache.xml.security.utils.Base64;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.NonceCache;
import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.callback.DecryptionKeyCallback;
import com.sun.xml.wss.impl.callback.EncryptionKeyCallback;
import com.sun.xml.wss.impl.callback.PasswordCallback;
import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import com.sun.xml.wss.impl.callback.PrefixNamespaceMappingCallback;
import com.sun.xml.wss.impl.callback.PropertyCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureVerificationKeyCallback;
import com.sun.xml.wss.impl.callback.UsernameCallback;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;

public class DefaultSecurityEnvironmentImpl
implements SecurityEnvironment {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    CallbackHandler callbackHandler;
    long MAX_CLOCK_SKEW = 60000L;
    long MAX_NONCE_AGE = 0x6DDD00L;
    long TIMESTAMP_FRESHNESS_LIMIT = 300000L;
    private boolean timeRelatedDefaultsUpdated = false;
    NonceCache nonceCache = null;
    final boolean USE_DAEMON_THREAD = true;
    final Timer nonceCleanupTimer = new Timer(true);
    private static final SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'sss'Z'");

    public DefaultSecurityEnvironmentImpl(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public X509Certificate getDefaultCertificate() throws XWSSecurityException {
        X509Certificate defaultCert = null;
        SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.DefaultPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        defaultCert = privKeyRequest.getX509Certificate();
        if (defaultCert == null) {
            log.log(Level.SEVERE, "WSS0218.cannot.locate.default.cert");
            throw new XWSSecurityException("Unable to locate a default certificate");
        }
        return defaultCert;
    }

    public PrivateKey getDefaultPrivateKey() throws XWSSecurityException {
        PrivateKey defaultPrivKey = null;
        SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.DefaultPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        defaultPrivKey = privKeyRequest.getPrivateKey();
        if (defaultPrivKey == null) {
            log.log(Level.SEVERE, "WSS0219.cannot.locate.default.privkey");
            throw new XWSSecurityException("Unable to locate a default certificate");
        }
        return defaultPrivKey;
    }

    public SecretKey getSecretKey(String alias, boolean encryptMode) throws XWSSecurityException {
        SecretKey symmetricKey = null;
        if (encryptMode) {
            EncryptionKeyCallback.AliasSymmetricKeyRequest symmKeyRequest = new EncryptionKeyCallback.AliasSymmetricKeyRequest(alias);
            EncryptionKeyCallback encKeyCallback = new EncryptionKeyCallback(symmKeyRequest);
            Callback[] callbacks = new Callback[]{encKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"EncryptionKeyCallback.AliasSymmetricKeyRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            symmetricKey = symmKeyRequest.getSymmetricKey();
        } else {
            DecryptionKeyCallback.AliasSymmetricKeyRequest symmKeyRequest = new DecryptionKeyCallback.AliasSymmetricKeyRequest(alias);
            DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(symmKeyRequest);
            Callback[] callbacks = new Callback[]{decryptKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.AliasSymmetricKeyRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            symmetricKey = symmKeyRequest.getSymmetricKey();
        }
        if (symmetricKey == null) {
            log.log(Level.SEVERE, "WSS0220.cannot.locate.symmetrickey.for.decrypt");
            throw new XWSSecurityException("Could not locate the symmetric key for alias " + alias);
        }
        return symmetricKey;
    }

    public X509Certificate getCertificate(String alias, boolean forSigning) throws XWSSecurityException {
        Object certRequest;
        X509Certificate cert = null;
        if (alias == null && forSigning) {
            return this.getDefaultCertificate();
        }
        if (forSigning) {
            certRequest = new SignatureKeyCallback.AliasPrivKeyCertRequest(alias);
            SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback((SignatureKeyCallback.Request)certRequest);
            Callback[] callbacks = new Callback[]{sigKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.AliasPrivKeyCertRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            cert = ((SignatureKeyCallback.PrivKeyCertRequest)certRequest).getX509Certificate();
        } else {
            certRequest = new EncryptionKeyCallback.AliasX509CertificateRequest(alias);
            EncryptionKeyCallback encKeyCallback = new EncryptionKeyCallback((EncryptionKeyCallback.Request)certRequest);
            Callback[] callbacks = new Callback[]{encKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"EncryptionKeyCallback.AliasX509CertificateRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            cert = ((EncryptionKeyCallback.X509CertificateRequest)certRequest).getX509Certificate();
        }
        if (cert == null) {
            String val = forSigning ? "Signature" : "Key Ecnryption";
            log.log(Level.SEVERE, "WSS0221.cannot.locate.cert", new Object[]{val});
            throw new XWSSecurityException("Unable to locate certificate for the alias " + alias);
        }
        return cert;
    }

    public X509Certificate getCertificate(PublicKey publicKey) throws XWSSecurityException {
        throw new XWSSecurityException("getCertificate(PublicKey) has not been implemented currently");
    }

    public PrivateKey getPrivateKey(String alias) throws XWSSecurityException {
        PrivateKey privKey = null;
        if (alias == null) {
            return this.getDefaultPrivateKey();
        }
        SignatureKeyCallback.AliasPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.AliasPrivKeyCertRequest(alias);
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.AliasPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privKey = privKeyRequest.getPrivateKey();
        if (privKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{alias});
            throw new XWSSecurityException("Unable to locate private key for the alias " + alias);
        }
        return privKey;
    }

    public PrivateKey getPrivateKey(byte[] keyIdentifier) throws XWSSecurityException {
        PrivateKey privateKey = null;
        DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest privKeyRequest = new DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest(keyIdentifier);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privKeyRequest);
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privateKey = privKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{keyIdentifier});
            throw new XWSSecurityException("No Matching private key for " + Base64.encode(keyIdentifier) + " subject key identifier found");
        }
        return privateKey;
    }

    public PrivateKey getPrivateKey(X509Certificate cert) throws XWSSecurityException {
        PrivateKey privateKey = null;
        DecryptionKeyCallback.X509CertificateBasedRequest privateKeyRequest = new DecryptionKeyCallback.X509CertificateBasedRequest(cert);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privateKeyRequest);
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.X509CertificateBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privateKey = privateKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{"given certificate"});
            throw new XWSSecurityException("Could not retrieve private Key matching the given certificate");
        }
        return privateKey;
    }

    public PrivateKey getPrivateKey(BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        PrivateKey privateKey = null;
        DecryptionKeyCallback.X509IssuerSerialBasedRequest privKeyRequest = new DecryptionKeyCallback.X509IssuerSerialBasedRequest(issuerName, serialNumber);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privKeyRequest);
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.X509IssuerSerialBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privateKey = privKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{serialNumber + ":" + issuerName});
            throw new XWSSecurityException("No Matching private key for serial number " + serialNumber + " and issuer name " + issuerName + " found");
        }
        return privateKey;
    }

    public PrivateKey getPrivateKey(PublicKey publicKey) throws XWSSecurityException {
        throw new UnsupportedOperationException("This method has not been implemented currently");
    }

    public PublicKey getPublicKey(byte[] keyIdentifier) throws XWSSecurityException {
        return this.getCertificate(keyIdentifier).getPublicKey();
    }

    public X509Certificate getCertificate(byte[] keyIdentifier) throws XWSSecurityException {
        X509Certificate cert = null;
        SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest certRequest = new SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest(keyIdentifier);
        SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(certRequest);
        Callback[] callbacks = new Callback[]{verifyKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        cert = certRequest.getX509Certificate();
        if (cert == null) {
            log.log(Level.SEVERE, "WSS0221.cannot.locate.cert", new Object[]{keyIdentifier});
            throw new XWSSecurityException("No Matching public key for " + Base64.encode(keyIdentifier) + " subject key identifier found");
        }
        return cert;
    }

    public PublicKey getPublicKey(BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        return this.getCertificate(serialNumber, issuerName).getPublicKey();
    }

    public X509Certificate getCertificate(BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        X509Certificate cert = null;
        SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest certRequest = new SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest(issuerName, serialNumber);
        SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(certRequest);
        Callback[] callbacks = new Callback[]{verifyKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        cert = certRequest.getX509Certificate();
        if (cert == null) {
            log.log(Level.SEVERE, "WSS0221.cannot.locate.cert", new Object[]{serialNumber + ":" + issuerName});
            throw new XWSSecurityException("No Matching public key for serial number " + serialNumber + " and issuer name " + issuerName + " found");
        }
        return cert;
    }

    public String getUsername() throws XWSSecurityException {
        UsernameCallback usernameCallback = new UsernameCallback();
        Callback[] callbacks = new Callback[]{usernameCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"UsernameCallback"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        return usernameCallback.getUsername();
    }

    public String getPassword() throws XWSSecurityException {
        PasswordCallback passwordCallback = new PasswordCallback();
        Callback[] callbacks = new Callback[]{passwordCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e.getMessage(), e);
        }
        return passwordCallback.getPassword();
    }

    public boolean authenticateUser(String username, String password) {
        PasswordValidationCallback.PlainTextPasswordRequest request = new PasswordValidationCallback.PlainTextPasswordRequest(username, password);
        PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
        Callback[] callbacks = new Callback[]{passwordValidationCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            // empty catch block
        }
        return passwordValidationCallback.getResult();
    }

    public boolean authenticateUser(String username, String passwordDigest, String nonce, String created) throws XWSSecurityException {
        PasswordValidationCallback.DigestPasswordRequest request = new PasswordValidationCallback.DigestPasswordRequest(username, passwordDigest, nonce, created);
        PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
        Callback[] callbacks = new Callback[]{passwordValidationCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            // empty catch block
        }
        return passwordValidationCallback.getResult();
    }

    public Subject getSubject() {
        throw new UnsupportedOperationException("This environment does not have an associated Subject");
    }

    public boolean validateAndCacheNonce(String nonce, String created) {
        if (this.nonceCache == null) {
            this.nonceCache = new NonceCache();
            log.log(Level.FINE, "Creating NonceCache for first time....." + this.nonceCache);
        } else if (this.nonceCache.wasCanceled()) {
            this.nonceCache = null;
            this.nonceCache = new NonceCache();
            log.log(Level.FINE, "Re-Creating NonceCache because it was canceled....." + this.nonceCache);
        }
        if (!this.nonceCache.isScheduled()) {
            log.log(Level.FINE, "About to Store a new Nonce, but Reclaimer not Scheduled, so scheduling one" + this.nonceCache);
            this.setNonceCacheCleanup(true);
        }
        return this.nonceCache.validateAndCacheNonce(nonce, created);
    }

    public boolean validateCreationTime(String creationTime) throws XWSSecurityException {
        try {
            Date created;
            try {
                created = calendarFormatter1.parse(creationTime);
            }
            catch (ParseException pe) {
                created = calendarFormatter2.parse(creationTime);
            }
            Date current = this.getFreshnessAndSkewAdjustedDate();
            log.log(Level.FINE, "Time at which token was created: " + created.toString());
            log.log(Level.FINE, "Current time: " + current.toString());
            if (created.before(current)) {
                log.log(Level.SEVERE, "WSS0341.created.older.than.timestamp.freshness");
                return false;
            }
            Date currentTime = this.getGMTDateWithSkewAdjusted(new GregorianCalendar(), true);
            if (currentTime.before(created)) {
                log.log(Level.SEVERE, "WSS0340.created.ahead.of.current");
                return false;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0328.error.parsing.creationtime");
            throw new XWSSecurityException(e);
        }
        return true;
    }

    public boolean validateExpirationTime(String expirationTime) throws XWSSecurityException {
        if (expirationTime != null) {
            try {
                Date expires;
                try {
                    expires = calendarFormatter1.parse(expirationTime);
                }
                catch (ParseException pe) {
                    expires = calendarFormatter2.parse(expirationTime);
                }
                Date currentTime = this.getGMTDateWithSkewAdjusted(new GregorianCalendar(), false);
                if (expires.before(currentTime)) {
                    log.log(Level.SEVERE, "WSS0393.current.ahead.of.expires");
                    return false;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0394.error.parsing.expirationtime");
                throw new XWSSecurityException(e);
            }
        }
        return true;
    }

    public boolean validateCertificate(X509Certificate cert) throws XWSSecurityException {
        CertificateValidationCallback certValCallback = new CertificateValidationCallback(cert);
        Callback[] callbacks = new Callback[]{certValCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e.getMessage(), e);
        }
        return certValCallback.getResult();
    }

    public void updateOtherPartySubject(Subject subject, String username, String password) {
        String x500Name = "CN=" + username;
        X500Principal principal = new X500Principal(x500Name);
        subject.getPrincipals().add(principal);
        subject.getPrivateCredentials().add(password);
    }

    public void updateOtherPartySubject(Subject subject, X509Certificate cert) {
        X500Principal principal = cert.getSubjectX500Principal();
        subject.getPrincipals().add(principal);
        subject.getPublicCredentials().add(cert);
    }

    private Date getFreshnessAndSkewAdjustedDate() throws ParseException {
        this.updateTimeRelatedDefaults();
        GregorianCalendar c = new GregorianCalendar();
        long offset = c.get(15);
        if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        long adjustedTime = currentTime - this.MAX_CLOCK_SKEW - this.TIMESTAMP_FRESHNESS_LIMIT;
        c.setTimeInMillis(adjustedTime);
        return c.getTime();
    }

    public void setNonceCacheCleanup(boolean enableStatus) {
        if (enableStatus) {
            this.updateTimeRelatedDefaults();
            if (!this.nonceCache.isScheduled()) {
                log.log(Level.FINE, "Scheduling Nonce Reclaimer task...... for " + this + ":" + this.nonceCache);
                this.nonceCleanupTimer.schedule((TimerTask)this.nonceCache, this.MAX_NONCE_AGE, this.MAX_NONCE_AGE);
                this.nonceCache.scheduled(true);
            }
        } else if (this.nonceCache.isScheduled()) {
            this.nonceCache.cancel();
            this.nonceCache.scheduled(false);
        }
    }

    public boolean validateSamlIssuer(String issuer) {
        throw new UnsupportedOperationException();
    }

    public boolean validateSamlUser(String user, String domain, String format) {
        throw new UnsupportedOperationException();
    }

    public void destroy() {
        if (this.nonceCache.isScheduled()) {
            this.setNonceCacheCleanup(false);
        }
        this.nonceCache = null;
    }

    public void setSubject(Subject subject) {
        throw new UnsupportedOperationException("Setting a Subject is not allowed");
    }

    private Date getGMTDateWithSkewAdjusted(Calendar c, boolean addSkew) {
        this.updateTimeRelatedDefaults();
        long offset = c.get(15);
        if (c.getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)c.getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += this.MAX_CLOCK_SKEW) : (currentTime -= this.MAX_CLOCK_SKEW);
        c.setTimeInMillis(currentTime);
        return c.getTime();
    }

    public Properties getPrefixNamespaceMappings() throws XWSSecurityException {
        PrefixNamespaceMappingCallback prefixNamespaceCallback = new PrefixNamespaceMappingCallback();
        Callback[] callbacks = new Callback[]{prefixNamespaceCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException ex) {
            return null;
        }
        catch (Exception e) {
            throw new XWSSecurityException(e.getMessage(), e);
        }
        return prefixNamespaceCallback.getMappings();
    }

    private void updateTimeRelatedDefaults() {
        if (this.timeRelatedDefaultsUpdated) {
            return;
        }
        this.timeRelatedDefaultsUpdated = true;
        PropertyCallback propCallback = new PropertyCallback();
        Callback[] callbacks = new Callback[]{propCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException ex) {
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0215.failed.propertycallback", e);
        }
        this.MAX_CLOCK_SKEW = propCallback.getMaxClockSkew();
        this.TIMESTAMP_FRESHNESS_LIMIT = propCallback.getTimestampFreshnessLimit();
        this.MAX_NONCE_AGE = propCallback.getMaxNonceAge();
    }
}

