/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.helpers;

import com.sun.org.apache.xml.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.security.keys.content.KeyValue;
import com.sun.org.apache.xml.security.keys.content.X509Data;
import com.sun.org.apache.xml.security.utils.Base64;
import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.ReferenceElement;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.SecurityToken;
import com.sun.xml.wss.SecurityTokenReference;
import com.sun.xml.wss.X509SecurityToken;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.reference.DirectReference;
import com.sun.xml.wss.reference.KeyIdentifier;
import com.sun.xml.wss.reference.X509IssuerSerial;
import java.math.BigInteger;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class KeyResolver {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");

    /*
     * WARNING - void declaration
     */
    public static Key getKey(KeyInfoHeaderBlock keyInfo, boolean sig, SecurableSoapMessage secureMsg) throws XWSSecurityException {
        void var3_7;
        block13: {
            try {
                Key returnKey;
                if (keyInfo.containsSecurityTokenReference()) {
                    SecurityTokenReference str = keyInfo.getSecurityTokenReference(0);
                    ReferenceElement refElement = str.getReference();
                    if (refElement instanceof KeyIdentifier) {
                        returnKey = sig ? secureMsg.getSecurityEnvironment().getPublicKey(KeyResolver.getDecodedBase64EncodedData(((KeyIdentifier)refElement).getReferenceValue())) : secureMsg.getSecurityEnvironment().getPrivateKey(KeyResolver.getDecodedBase64EncodedData(((KeyIdentifier)refElement).getReferenceValue()));
                        break block13;
                    }
                    if (refElement instanceof DirectReference) {
                        String uri = ((DirectReference)refElement).getURI();
                        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(((DirectReference)refElement).getValueType())) {
                            String wsuId = secureMsg.getIdFromFragmentRef(uri);
                            X509SecurityToken token = (X509SecurityToken)secureMsg.getToken(wsuId);
                            returnKey = KeyResolver.resolveX509Token(secureMsg, token, sig);
                            break block13;
                        }
                        if (null == ((DirectReference)refElement).getValueType()) {
                            String wsuId = secureMsg.getIdFromFragmentRef(uri);
                            SecurityToken token = secureMsg.getToken(wsuId);
                            if (token instanceof X509SecurityToken) {
                                returnKey = KeyResolver.resolveX509Token(secureMsg, (X509SecurityToken)token, sig);
                                break block13;
                            }
                            String message = " Cannot Resolve URI " + uri;
                            log.log(Level.SEVERE, "WSS0337.unsupported.directref.mechanism", new Object[]{message});
                            XWSSecurityException xwsse = new XWSSecurityException(message);
                            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, xwsse.getMessage(), xwsse);
                        }
                        log.log(Level.SEVERE, "WSS0337.unsupported.directref.mechanism", new Object[]{((DirectReference)refElement).getValueType()});
                        XWSSecurityException xwsse = new XWSSecurityException("Unsupported DirectReference ValueType " + ((DirectReference)refElement).getValueType());
                        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
                    }
                    if (refElement instanceof X509IssuerSerial) {
                        BigInteger serialNumber = ((X509IssuerSerial)refElement).getSerialNumber();
                        String issuerName = ((X509IssuerSerial)refElement).getIssuerName();
                        returnKey = sig ? secureMsg.getSecurityEnvironment().getPublicKey(serialNumber, issuerName) : secureMsg.getSecurityEnvironment().getPrivateKey(serialNumber, issuerName);
                        break block13;
                    }
                    log.log(Level.SEVERE, "WSS0338.unsupported.reference.mechanism");
                    XWSSecurityException xwsse = new XWSSecurityException("Key reference mechanism not supported");
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
                }
                if (keyInfo.containsKeyName()) {
                    String keynameString = keyInfo.getKeyNameString(0);
                    returnKey = secureMsg.getSecurityEnvironment().getSecretKey(keynameString, false);
                    break block13;
                }
                if (keyInfo.containsKeyValue()) {
                    returnKey = KeyResolver.resolveKeyValue(secureMsg, keyInfo.getKeyValue(0), sig);
                    break block13;
                }
                if (keyInfo.containsX509Data()) {
                    returnKey = KeyResolver.resolveX509Data(secureMsg, keyInfo.getX509Data(0), sig);
                    break block13;
                }
                log.log(Level.SEVERE, "WSS0339.unsupported.keyinfo");
                XWSSecurityException xwsse = new XWSSecurityException("Support for processing information in the given ds:KeyInfo is not present");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
            }
            catch (XWSSecurityException xwsse) {
                log.log(Level.SEVERE, "WSS0800.error.resolving.key", new Object[]{xwsse.getMessage()});
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, xwsse.getMessage(), xwsse);
            }
        }
        if (var3_7 == null) {
            log.log(Level.SEVERE, "WSS0600.illegal.token.reference");
            XWSSecurityException xwsse = new XWSSecurityException("Referenced security token could not be retrieved");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, xwsse.getMessage(), xwsse);
        }
        return var3_7;
    }

    public static Key resolveX509Token(SecurableSoapMessage secureMsg, X509SecurityToken token, boolean sig) throws XWSSecurityException {
        if (sig) {
            SecurityEnvironment secDomain;
            X509Certificate cert = token.getCertificate();
            Subject otherPartySubject = secureMsg.getSubject();
            if (otherPartySubject == null) {
                otherPartySubject = new Subject();
                secureMsg.setSubject(otherPartySubject);
            }
            if (null != (secDomain = secureMsg.getSecurityEnvironment())) {
                secDomain.updateOtherPartySubject(otherPartySubject, cert);
            }
            return cert.getPublicKey();
        }
        return secureMsg.getSecurityEnvironment().getPrivateKey(token.getCertificate());
    }

    public static Key resolveKeyValue(SecurableSoapMessage secureMsg, KeyValue keyValue, boolean sig) throws XWSSecurityException {
        keyValue.getElement().normalize();
        try {
            if (sig) {
                return keyValue.getPublicKey();
            }
            return secureMsg.getSecurityEnvironment().getPrivateKey(keyValue.getPublicKey());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0601.illegal.key.value", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    public static Key resolveX509Data(SecurableSoapMessage secureMsg, X509Data x509Data, boolean sig) throws XWSSecurityException {
        x509Data.getElement().normalize();
        X509Certificate cert = null;
        SecurityEnvironment secEnv = secureMsg.getSecurityEnvironment();
        try {
            if (!x509Data.containsCertificate()) {
                if (x509Data.containsSKI()) {
                    if (sig) {
                        return secEnv.getPublicKey(x509Data.itemSKI(0).getSKIBytes());
                    }
                    return secEnv.getPrivateKey(x509Data.itemSKI(0).getSKIBytes());
                }
                if (x509Data.containsSubjectName()) {
                    log.log(Level.SEVERE, "WSS0339.unsupported.keyinfo");
                    throw new XWSSecurityException("X509SubjectName child element of X509Data is not yet supported by our implementation");
                }
                if (x509Data.containsIssuerSerial()) {
                    if (sig) {
                        return secEnv.getPublicKey(x509Data.itemIssuerSerial(0).getSerialNumber(), x509Data.itemIssuerSerial(0).getIssuerName());
                    }
                    return secEnv.getPrivateKey(x509Data.itemIssuerSerial(0).getSerialNumber(), x509Data.itemIssuerSerial(0).getIssuerName());
                }
                log.log(Level.SEVERE, "WSS0339.unsupported.keyinfo");
                throw new XWSSecurityException("Unsupported child element of X509Data encountered");
            }
            cert = x509Data.itemCertificate(0).getX509Certificate();
            if (sig) {
                return cert.getPublicKey();
            }
            return secEnv.getPrivateKey(cert);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0602.illegal.x509.data", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    private static byte[] getDecodedBase64EncodedData(String encodedData) throws XWSSecurityException {
        try {
            return Base64.decode(encodedData);
        }
        catch (Base64DecodingException e) {
            log.log(Level.SEVERE, "WSS0144.unableto.decode.base64.data", new Object[]{e.getMessage()});
            throw new XWSSecurityException("Unable to decode Base64 encoded data", e);
        }
    }
}

