/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.DecryptReferenceListFilter;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.filter.ImportCertificateTokenFilter;
import com.sun.xml.wss.filter.ImportEncryptedKeyFilter;
import com.sun.xml.wss.filter.ImportReferenceListFilter;
import com.sun.xml.wss.filter.ImportSamlAssertionFilter;
import com.sun.xml.wss.filter.ImportSecurityTokenReferenceFilter;
import com.sun.xml.wss.filter.ImportTimestampFilter;
import com.sun.xml.wss.filter.ImportUsernameTokenFilter;
import com.sun.xml.wss.filter.VerifyFilter;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;

public class ProcessSecurityHeaderFilter
extends FilterBase
implements MessageFilter {
    private SOAPElement currentElement = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        SecurityHeader securityHeader = secureMessage.findSecurityHeader();
        if (null == securityHeader) {
            log.log(Level.WARNING, "Message does not contain wsse:Security header");
            return;
        }
        try {
            this.currentElement = this.getNextChildElement(securityHeader);
            while (this.currentElement != null) {
                String elementName = this.currentElement.getLocalName();
                if ("BinarySecurityToken".equals(elementName)) {
                    new ImportCertificateTokenFilter().process(secureMessage);
                } else if ("UsernameToken".equals(elementName)) {
                    new ImportUsernameTokenFilter().process(secureMessage);
                } else if ("Timestamp".equals(elementName)) {
                    new ImportTimestampFilter().process(secureMessage);
                } else if ("Signature".equals(elementName)) {
                    new VerifyFilter().process(secureMessage);
                } else if ("EncryptedKey".equals(elementName)) {
                    new ImportEncryptedKeyFilter().process(secureMessage);
                    new DecryptReferenceListFilter().process(secureMessage);
                } else if ("ReferenceList".equals(elementName)) {
                    new ImportReferenceListFilter().process(secureMessage);
                    new DecryptReferenceListFilter().process(secureMessage);
                } else if ("Assertion".equals(elementName)) {
                    new ImportSamlAssertionFilter().process(secureMessage);
                } else if ("SecurityTokenReference".equals(elementName)) {
                    new ImportSecurityTokenReferenceFilter().process(secureMessage);
                } else {
                    XWSSecurityException xwsse = new XWSSecurityException("Unrecognized header block: " + this.currentElement.getTagName());
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, xwsse.getMessage(), xwsse);
                }
                this.currentElement = this.getNextChildElement(securityHeader);
            }
        }
        finally {
            this.currentElement = null;
        }
    }

    private SOAPElement getNextChildElement(SecurityHeader header) {
        org.w3c.dom.Node nextChild;
        if (this.currentElement == null) {
            return this.getFirstChildElement(header);
        }
        for (nextChild = this.currentElement.getNextSibling(); !(nextChild instanceof SOAPElement) && null != nextChild; nextChild = nextChild.getNextSibling()) {
        }
        return (SOAPElement)nextChild;
    }

    private SOAPElement getFirstChildElement(SecurityHeader header) {
        Iterator eachChild = header.getChildElements();
        Node node = null;
        while (!(node instanceof SOAPElement) && eachChild.hasNext()) {
            node = (Node)eachChild.next();
        }
        if (node instanceof SOAPElement) {
            return (SOAPElement)node;
        }
        return null;
    }
}

