/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.ExtendedMessageFilter;
import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.PolicyViolationException;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.UsernameToken;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.configuration.SecurityRequirement;
import com.sun.xml.wss.configuration.SecurityRequirements;
import com.sun.xml.wss.configuration.UsernamePasswordRequirement;
import com.sun.xml.wss.filter.FilterBase;
import java.util.logging.Level;
import javax.security.auth.Subject;

public class ImportUsernameTokenFilter
extends FilterBase
implements ExtendedMessageFilter {
    private boolean enableLogging = false;
    SecurityRequirement receiverRequirement = null;

    public ImportUsernameTokenFilter() {
    }

    public ImportUsernameTokenFilter(SecurityRequirement receiverRequirement) {
        this.receiverRequirement = receiverRequirement;
    }

    public void setReceiverRequirement(SecurityRequirement requirement) {
        this.receiverRequirement = requirement;
    }

    public void setReceiverRequirements(SecurityRequirements requirements) throws UnsupportedOperationException {
        log.log(Level.SEVERE, "WSS0207.unsupported.operation.exception");
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void enableOperationsLog(boolean enable) {
        this.enableLogging = enable;
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        SecurityHeader wsseSecurity = secureMessage.findSecurityHeader();
        UsernameToken token = null;
        try {
            token = (UsernameToken)wsseSecurity.getCurrentHeaderBlock(UsernameToken.class);
        }
        catch (XWSSecurityException ex) {
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Exception while importing Username Password Token", ex);
        }
        SecurityEnvironment secDomain = secureMessage.getSecurityEnvironment();
        if (secDomain == null) {
            log.log(Level.SEVERE, "WSS0184.SecurityEnvironment.null");
            throw new XWSSecurityException("Security Domain not set on the Message");
        }
        String username = token.getUsername();
        String password = token.getPassword();
        String passwordDigest = token.getPasswordDigest();
        String passwordType = token.getPasswordType();
        String nonce = token.getNonce();
        String created = token.getCreated();
        boolean authenticated = false;
        if (this.receiverRequirement != null) {
            boolean nonceRequired = ((UsernamePasswordRequirement)this.receiverRequirement).getNonceRequired();
            boolean passwordDigestRequired = ((UsernamePasswordRequirement)this.receiverRequirement).getPasswordDigestRequired();
            if (passwordDigestRequired && passwordDigest == null) {
                log.log(Level.SEVERE, "WSS0212.policy.violation.exception");
                throw new PolicyViolationException("Receiver Requirement for Digested Password has not been met");
            }
            if (nonceRequired && nonce == null) {
                log.log(Level.SEVERE, "WSS0213.policy.violation.exception");
                throw new PolicyViolationException("Receiver Requirement for nonce has not been met");
            }
        }
        try {
            authenticated = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(passwordType) ? secDomain.authenticateUser(username, password) : secDomain.authenticateUser(username, passwordDigest, nonce, created);
            if (!authenticated) {
                log.log(Level.SEVERE, "WSS0214.failed.sender.authentication");
                XWSSecurityException xwse = new XWSSecurityException("Invalid Username Password Pair");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Authentication of Username Password Token Failed", xwse);
            }
            if (nonce != null && !secDomain.validateAndCacheNonce(nonce, created)) {
                XWSSecurityException xwse = new XWSSecurityException("Invalid Nonce value for Username Token");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Invalid Nonce value for Username Token", xwse);
            }
            if (created != null && !secDomain.validateCreationTime(created)) {
                XWSSecurityException xwse = new XWSSecurityException("Invalid creation-time value for Username Token");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Invalid creation-time value for Username Token", xwse);
            }
        }
        catch (XWSSecurityException xwsse) {
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, xwsse.getMessage(), xwsse);
        }
        Subject subject = secureMessage.getSubject();
        if (subject == null) {
            subject = new Subject();
            secureMessage.setSubject(subject);
        }
        secDomain.updateOtherPartySubject(subject, username, password);
        if (this.enableLogging) {
            secureMessage.logUsernameToken(nonce != null ? "true" : "false", passwordDigest != null ? "true" : "false");
        }
    }
}

