/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.Timestamp;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ImportTimestampFilter
extends FilterBase
implements MessageFilter {
    private static final SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'sss'Z'");

    public void process(SecurableSoapMessage secureMsg) throws XWSSecurityException {
        SecurityHeader secHeader = secureMsg.findSecurityHeader();
        try {
            Timestamp ts = (Timestamp)secHeader.getCurrentHeaderBlock(Timestamp.class);
            SecurityEnvironment secEnv = secureMsg.getSecurityEnvironment();
            if (this.expiresBeforeCreated(ts.getCreated(), ts.getExpires())) {
                XWSSecurityException xwsse = new XWSSecurityException("Message expired!");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSU_MESSAGE_EXPIRED, "Message expired!", xwsse);
            }
            if (!secEnv.validateCreationTime(ts.getCreated())) {
                XWSSecurityException xwsse = new XWSSecurityException("Invalid creation time value in Timestamp");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Invalid creation time value in Timestamp", xwsse);
            }
            if (!secEnv.validateExpirationTime(ts.getExpires())) {
                XWSSecurityException xwsse = new XWSSecurityException("Message expired!");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSU_MESSAGE_EXPIRED, "Message expired!", xwsse);
            }
        }
        catch (XWSSecurityException xwsse) {
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Failure in Timestamp internalization.\nMessage is: " + xwsse.getMessage(), xwsse);
        }
    }

    private boolean expiresBeforeCreated(String creationTime, String expirationTime) throws XWSSecurityException {
        Date created = null;
        Date expires = null;
        try {
            try {
                created = calendarFormatter1.parse(creationTime);
                if (expirationTime != null) {
                    expires = calendarFormatter1.parse(expirationTime);
                }
            }
            catch (ParseException pe) {
                created = calendarFormatter2.parse(creationTime);
                if (expirationTime != null) {
                    expires = calendarFormatter2.parse(expirationTime);
                }
            }
        }
        catch (ParseException pe) {
            throw new XWSSecurityException(pe.getMessage());
        }
        return expires != null && expires.before(created);
    }
}

