/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.X509SecurityToken;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import java.security.cert.X509Certificate;
import java.util.logging.Level;

public class ImportCertificateTokenFilter
extends FilterBase
implements MessageFilter {
    private boolean validateCert = true;

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        SecurityHeader wsseSecurity = secureMessage.findSecurityHeader();
        X509SecurityToken token = null;
        try {
            token = (X509SecurityToken)wsseSecurity.getCurrentHeaderBlock(X509SecurityToken.class);
        }
        catch (XWSSecurityException ex) {
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Exception while importing X509Certificate Token", ex);
        }
        String tokenId = token.getId();
        secureMessage.setToken(tokenId, token);
        secureMessage.setFilterParameter("TokenId", tokenId);
        secureMessage.setFilterParameter("Token", token);
        try {
            SecurityEnvironment secEnv;
            X509Certificate cert = token.getCertificate();
            if (this.validateCert && !(secEnv = secureMessage.getSecurityEnvironment()).validateCertificate(cert)) {
                throw new XWSSecurityException("Certificate validation failed");
            }
        }
        catch (XWSSecurityException xwsse) {
            log.log(Level.SEVERE, "WSS0156.exception.in.cert.validate", new Object[]{xwsse.getMessage()});
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
        }
    }
}

