/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.KeyInfoStrategy;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.XWSSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public abstract class FilterBase
implements MessageFilter {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    protected HashMap filterParameters = new HashMap();
    protected KeyInfoStrategy keyInfoStrategy;
    protected ArrayList targets;
    protected static final String DIRECT_REFERENCE_STRATEGY = "com.sun.xml.wss.keyinfo.DirectReferenceStrategy";
    protected static final String KEY_IDENTIFIER_STRATEGY = "com.sun.xml.wss.keyinfo.KeyIdentifierStrategy";
    protected static final String KEY_NAME_STRATEGY = "com.sun.xml.wss.keyinfo.KeyNameStrategy";
    protected static final String X509_ISSUER_SERIAL_STRATEGY = "com.sun.xml.wss.keyinfo.X509IssuerSerialStrategy";

    public void setParameter(String name, String value) {
        this.filterParameters.put(name, value);
    }

    public void setTargetList(ArrayList targetList) {
        this.targets = targetList;
    }

    public void setKeyInfoStrategyParameter(KeyInfoStrategy strategy) {
        this.keyInfoStrategy = strategy;
    }

    public String getParameter(String name) {
        return (String)this.filterParameters.get(name);
    }

    public void init() throws XWSSecurityException {
    }

    protected static KeyInfoStrategy getKeyInfoStrategy(String strategyName) throws XWSSecurityException {
        String className = strategyName;
        if ("DirectReferenceStrategy".equals(strategyName)) {
            className = DIRECT_REFERENCE_STRATEGY;
        } else if ("KeyIdentifierStrategy".equals(strategyName)) {
            className = KEY_IDENTIFIER_STRATEGY;
        } else if ("KeyNameStrategy".equals(strategyName)) {
            className = KEY_NAME_STRATEGY;
        } else if ("X509IssuerSerialStrategy".equals(strategyName)) {
            className = X509_ISSUER_SERIAL_STRATEGY;
        }
        try {
            return (KeyInfoStrategy)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }
}

