/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SamlAssertionHeaderBlock;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.SignatureHeaderBlock;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.saml.assertion.Assertion;
import com.sun.xml.wss.saml.common.SAMLException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;

public class ExportSamlAssertionFilter
extends FilterBase
implements MessageFilter {
    private Assertion assertion_ = null;
    private String aliasForSigning = null;

    public ExportSamlAssertionFilter(Assertion assertion) throws XWSSecurityException {
        if (null == assertion) {
            throw new XWSSecurityException("Assertion may not be null.");
        }
        this.assertion_ = assertion;
    }

    public ExportSamlAssertionFilter(Assertion assertion, String aliasForSigning) throws XWSSecurityException {
        if (null == assertion) {
            throw new XWSSecurityException("Assertion may not be null.");
        }
        this.assertion_ = assertion;
        this.aliasForSigning = aliasForSigning;
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        SecurityHeader securityHeader = secureMessage.findOrCreateSecurityHeader();
        SOAPElement samlElement = null;
        try {
            samlElement = (SOAPElement)this.assertion_.toElement((Document)secureMessage.getSOAPPart(), (short)this.assertion_.getMinorVersion());
        }
        catch (SAMLException e) {
            throw new XWSSecurityException(e);
        }
        SamlAssertionHeaderBlock samlAssertionHeaderBlock = new SamlAssertionHeaderBlock(samlElement);
        PrivateKey privKey = null;
        SignatureHeaderBlock sigBlock = null;
        if (this.aliasForSigning != null) {
            X509Certificate cert = secureMessage.getSecurityEnvironment().getCertificate(this.aliasForSigning, true);
            privKey = secureMessage.getSecurityEnvironment().getPrivateKey(cert);
            sigBlock = samlAssertionHeaderBlock.addSignature(cert, privKey, "RSA", secureMessage);
        }
        securityHeader.insertHeaderBlock(samlAssertionHeaderBlock);
        if (sigBlock != null) {
            sigBlock.sign(privKey);
        }
        secureMessage.setToken(this.assertion_.getAssertionID(), samlAssertionHeaderBlock);
    }
}

