/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.org.apache.xml.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.security.encryption.XMLCipher;
import com.sun.org.apache.xml.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.security.keys.KeyInfo;
import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.KeyInfoStrategy;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.ReferenceListHeaderBlock;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExportEncryptedKeyFilter
extends FilterBase
implements MessageFilter {
    private String algorithm;
    private String x509TokenId;

    public ExportEncryptedKeyFilter() {
        this.algorithm = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    }

    public ExportEncryptedKeyFilter(String algorithm, KeyInfoStrategy keyInfoStrategy) throws XWSSecurityException {
        if (null == algorithm) {
            throw new XWSSecurityException("'algorithm' argument should not be null");
        }
        this.algorithm = algorithm;
        if (null == keyInfoStrategy) {
            throw new XWSSecurityException("'keyInfoStrategy' argument should not be null");
        }
        this.keyInfoStrategy = keyInfoStrategy;
    }

    public ExportEncryptedKeyFilter(KeyInfoStrategy keyInfoStrategy) throws XWSSecurityException {
        this("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", keyInfoStrategy);
    }

    public void init() throws XWSSecurityException {
        if (this.getParameter("x509TokenId") != null) {
            this.x509TokenId = this.getParameter("x509TokenId");
        }
        this.algorithm = this.getParameter("keyEncryptionAlgorithm");
    }

    public void process(SecurableSoapMessage secureMsg) throws XWSSecurityException {
        SOAPElement encKeySoapElement;
        SOAPPart soapPart = secureMsg.getSOAPPart();
        SecurityHeader secHeader = secureMsg.findOrCreateSecurityHeader();
        SecretKey symmetricKey = null;
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("DESede");
            keyGen.init(168);
            symmetricKey = keyGen.generateKey();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0168.failedto.generate.random.symmetrickey", new Object[]{e.getMessage()});
            throw new XWSSecurityException("Unable to Generate Symmetric Key", e);
        }
        secureMsg.setFilterParameter("SymmetricKey", symmetricKey);
        X509Certificate cert = this.getAssociatedCertificate(secureMsg);
        if (cert == null) {
            throw new XWSSecurityException("Could not retrieve certificate for encryption");
        }
        this.keyInfoStrategy.setCertificate(cert);
        try {
            XMLCipher xmlCipher = XMLCipher.getInstance(this.algorithm);
            xmlCipher.init(3, cert.getPublicKey());
            EncryptedKey encryptedKey = xmlCipher.encryptKey((Document)soapPart, symmetricKey);
            KeyInfoHeaderBlock keyInfoBlock = new KeyInfoHeaderBlock((Document)soapPart);
            this.keyInfoStrategy.insertKey(keyInfoBlock, secureMsg, this.x509TokenId);
            KeyInfo keyInfo = new KeyInfo((Element)keyInfoBlock.getAsSoapElement(), null);
            encryptedKey.setKeyInfo(keyInfo);
            encKeySoapElement = (SOAPElement)xmlCipher.martial(encryptedKey);
        }
        catch (XMLSecurityException xse) {
            throw new XWSSecurityException(xse);
        }
        secHeader.insertHeaderBlockElement(encKeySoapElement);
        ReferenceListHeaderBlock referenceListBlock = new ReferenceListHeaderBlock((Document)soapPart);
        encKeySoapElement.appendChild((Node)referenceListBlock.getAsSoapElement());
        secureMsg.setFilterParameter("ReferenceList", referenceListBlock);
    }

    private X509Certificate getAssociatedCertificate(SecurableSoapMessage secureMsg) throws XWSSecurityException {
        String alias = this.keyInfoStrategy.getAlias();
        return secureMsg.getSecurityEnvironment().getCertificate(alias, false);
    }
}

