/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.org.apache.xml.security.encryption.XMLCipher;
import com.sun.org.apache.xml.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xpath.internal.XPathAPI;
import com.sun.xml.wss.EncryptedDataHeaderBlock;
import com.sun.xml.wss.ExtendedMessageFilter;
import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.PolicyViolationException;
import com.sun.xml.wss.ReferenceListHeaderBlock;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.Target;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.XWSSecurityRuntimeException;
import com.sun.xml.wss.configuration.AllowEncryption;
import com.sun.xml.wss.configuration.DecryptRequirement;
import com.sun.xml.wss.configuration.SecurityRequirement;
import com.sun.xml.wss.configuration.SecurityRequirements;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.helpers.KeyResolver;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DecryptReferenceListFilter
extends FilterBase
implements ExtendedMessageFilter {
    String algorithm = null;
    boolean enableLogging = false;
    ArrayList optionalTargets = null;
    SecurityRequirement receiverRequirement = null;

    public DecryptReferenceListFilter() {
    }

    public DecryptReferenceListFilter(SecurityRequirement receiverRequirement, ArrayList optionalTargets) {
        this.receiverRequirement = receiverRequirement;
        this.optionalTargets = optionalTargets;
    }

    public void setReceiverRequirement(SecurityRequirement requirement) {
        this.receiverRequirement = requirement;
    }

    public void setReceiverRequirements(SecurityRequirements requirements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void enableOperationsLog(boolean enable) {
        this.enableLogging = enable;
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        ReferenceListHeaderBlock refList = (ReferenceListHeaderBlock)secureMessage.getFilterParameter("ReferenceList");
        if (refList == null) {
            log.log(Level.SEVERE, "WSS0182.referencelist.parameter.null");
            throw new XWSSecurityException("REFERENCE_LIST parameter has a null value");
        }
        this.decryptReferenceList(refList, secureMessage);
    }

    private void decryptReferenceList(ReferenceListHeaderBlock refList, SecurableSoapMessage secureMessage) throws XWSSecurityException {
        boolean reqsSpecified;
        NodeList dataRefElements = refList.getDataRefElements();
        int numberOfEncryptedElems = refList.size();
        ArrayList targets = null;
        HashSet<Node> references = new HashSet<Node>();
        boolean partialReqsMet = false;
        boolean bl = reqsSpecified = this.receiverRequirement != null;
        if (reqsSpecified) {
            targets = this.receiverRequirement instanceof DecryptRequirement ? ((DecryptRequirement)this.receiverRequirement).getTargets() : ((AllowEncryption)this.receiverRequirement).getTargets();
        }
        for (int i = 0; i < numberOfEncryptedElems; ++i) {
            String refURI = ((SOAPElement)dataRefElements.item(i)).getAttribute("URI");
            SOAPElement encDataElement = null;
            try {
                encDataElement = (SOAPElement)XMLUtil.getElementById((Document)secureMessage.getSOAPPart(), refURI.substring(1));
            }
            catch (TransformerException te) {
                throw new XWSSecurityException(te.getMessage(), te);
            }
            EncryptedDataHeaderBlock xencEncryptedData = new EncryptedDataHeaderBlock(encDataElement);
            KeyInfoHeaderBlock keyInfo = xencEncryptedData.getKeyInfo();
            this.algorithm = xencEncryptedData.getEncryptionMethodURI();
            if (!"http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(this.algorithm)) {
                log.log(Level.SEVERE, "WSS0189.unsupported.data.decryption.algorithm");
                XWSSecurityException xwsse = new XWSSecurityException("Triple-des algorithm expected for data encryption");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_ALGORITHM, xwsse.getMessage(), xwsse);
            }
            SecretKey symmetricKey = keyInfo == null ? (SecretKey)secureMessage.getFilterParameter("SymmetricKey") : (SecretKey)KeyResolver.getKey(keyInfo, false, secureMessage);
            if (symmetricKey == null) {
                log.log(Level.SEVERE, "WSS0183.couldnot.locate.symmetrickey");
                throw new XWSSecurityException("Couldn't locate symmetricKey for decryption");
            }
            Node parent = encDataElement.getParentNode();
            Node prevSibling = encDataElement.getPreviousSibling();
            Node actualEncrypted = null;
            boolean contentOnly = false;
            XMLCipher xmlCipher = this.initXMLCipher(symmetricKey, secureMessage);
            this.decryptElementWithCipher(xmlCipher, encDataElement, secureMessage);
            if (xencEncryptedData.getType().equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#Content")) {
                actualEncrypted = this.resolveActualEncrypted(parent, prevSibling, true);
                contentOnly = true;
            } else if (xencEncryptedData.getType().equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#Element")) {
                actualEncrypted = this.resolveActualEncrypted(parent, prevSibling, false);
                contentOnly = false;
            }
            if (this.enableLogging) {
                references.add(actualEncrypted);
            }
            if (!reqsSpecified || (partialReqsMet = this.verifyIfReferenceExists(secureMessage, actualEncrypted, contentOnly, targets, partialReqsMet))) continue;
            String lname = actualEncrypted.getLocalName();
            String nspac = actualEncrypted.getNamespaceURI();
            try {
                Node newNode = parent.getOwnerDocument().importNode((Node)encDataElement, true);
                if (actualEncrypted == parent) {
                    if (contentOnly) {
                        while (parent.hasChildNodes()) {
                            parent.removeChild(parent.getFirstChild());
                        }
                        parent.appendChild(newNode);
                    } else {
                        parent.getParentNode().replaceChild(newNode, actualEncrypted);
                    }
                } else {
                    parent.replaceChild(newNode, actualEncrypted);
                }
            }
            catch (DOMException dme) {
                throw new XWSSecurityRuntimeException(dme);
            }
            throw new PolicyViolationException("Target of encryption: {" + nspac + "}" + lname + " does not meet the " + "receiver requirement");
        }
        if (this.enableLogging) {
            secureMessage.logEncryptionReferences(references);
        }
        if (reqsSpecified && numberOfEncryptedElems < this.getAllTargetElements(secureMessage, targets).size()) {
            log.log(Level.SEVERE, "WSS0190.encryption.requirements.not.met");
            PolicyViolationException pve = new PolicyViolationException("The number of elements encrypted is less than required/allowed");
            throw pve;
        }
    }

    private boolean verifyIfReferenceExists(SecurableSoapMessage ssm, Node actualEncrypted, boolean contentOnly, ArrayList targetList, boolean partialReqsMet) throws XWSSecurityException {
        EncryptedElement encryptedElement = new EncryptedElement((Element)actualEncrypted, contentOnly);
        Object target = null;
        Object targetType = null;
        Object targetValue = null;
        ArrayList targetElements = this.getAllTargetElements(ssm, targetList);
        boolean isSomeTarget = targetElements.contains(encryptedElement);
        if (!isSomeTarget) {
            if (this.optionalTargets != null && this.getAllTargetElements(ssm, this.optionalTargets).contains(encryptedElement)) {
                return true;
            }
            if (partialReqsMet) {
                throw new XWSSecurityException("Target of encryption: {" + actualEncrypted.getNamespaceURI() + "}" + actualEncrypted.getLocalName() + " does not meet the " + "receiver requirement");
            }
        }
        if (isSomeTarget) {
            partialReqsMet = true;
        }
        return partialReqsMet;
    }

    private ArrayList getAllTargetElements(SecurableSoapMessage ssm, ArrayList targetList) throws XWSSecurityException {
        ArrayList result = new ArrayList();
        Iterator it = targetList.iterator();
        while (it.hasNext()) {
            Element elem;
            Target target = (Target)it.next();
            String targetType = target.getType();
            String targetValue = target.getValue();
            boolean contentOnly = target.getContentOnly();
            if ("qname".equals(targetType)) {
                String xpath = XMLUtil.convertToXpath(targetValue);
                NodeList targetElements = null;
                try {
                    targetElements = XPathAPI.selectNodeList((Node)ssm.getSOAPPart(), xpath, ssm.getNSContext());
                }
                catch (Exception e) {
                    throw new XWSSecurityException(e);
                }
                this.contribute(targetElements, result, contentOnly);
                continue;
            }
            if ("xpath".equals(targetType)) {
                NodeList targetElements = null;
                try {
                    targetElements = XPathAPI.selectNodeList((Node)ssm.getSOAPPart(), targetValue, ssm.getNSContext());
                }
                catch (Exception e) {
                    throw new XWSSecurityException(e);
                }
                this.contribute(targetElements, result, contentOnly);
                continue;
            }
            if (!"uri".equals(targetType)) continue;
            try {
                elem = XMLUtil.getElementById((Document)ssm.getSOAPPart(), targetValue);
            }
            catch (Exception e) {
                throw new XWSSecurityException(e);
            }
            this.contribute(elem, result, contentOnly);
        }
        return result;
    }

    private void contribute(NodeList targetElements, ArrayList result, boolean contentOnly) {
        for (int i = 0; i < targetElements.getLength(); ++i) {
            EncryptedElement targetElement = new EncryptedElement((Element)targetElements.item(i), contentOnly);
            result.add(targetElement);
        }
    }

    private void contribute(Element element, ArrayList result, boolean contentOnly) {
        EncryptedElement targetElement = new EncryptedElement(element, contentOnly);
        result.add(targetElement);
    }

    private Node resolveActualEncrypted(Node parent, Node prevSibling, boolean contentOnly) {
        Node actualEncrypted = null;
        actualEncrypted = !contentOnly ? (prevSibling == null ? parent.getFirstChild() : prevSibling.getNextSibling()) : parent;
        return actualEncrypted;
    }

    private XMLCipher initXMLCipher(Key key, SecurableSoapMessage secureMessage) throws XWSSecurityException {
        XMLCipher xmlCipher;
        try {
            xmlCipher = XMLCipher.getInstance(this.algorithm);
            xmlCipher.init(2, key);
        }
        catch (XMLEncryptionException xee) {
            log.log(Level.SEVERE, "WSS0137.unableto.decrypt.message", new Object[]{xee.getMessage()});
            throw new XWSSecurityException("Unable to decrypt message", xee);
        }
        return xmlCipher;
    }

    private Document decryptElementWithCipher(XMLCipher xmlCipher, SOAPElement element, SecurableSoapMessage secureMessage) throws XWSSecurityException {
        Document document = null;
        element.normalize();
        try {
            document = xmlCipher.doFinal((Document)secureMessage.getSOAPPart(), (Element)element);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0137.unableto.decrypt.message", new Object[]{e.getMessage()});
            XWSSecurityException xse = new XWSSecurityException("Unable to decrypt message", e);
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, "Unable to decrypt message", xse);
        }
        return document;
    }

    private String convertToXpath(String qname) {
        QName name = QName.valueOf(qname);
        if ("".equals(name.getNamespaceURI())) {
            return "//" + name.getLocalPart();
        }
        return "//*[local-name()='" + name.getLocalPart() + "' and namespace-uri()='" + name.getNamespaceURI() + "']";
    }

    private ArrayList copyList(ArrayList parent) {
        if (parent == null) {
            return null;
        }
        ArrayList child = new ArrayList();
        Iterator listIter = parent.iterator();
        while (listIter.hasNext()) {
            child.add(listIter.next());
        }
        return child;
    }

    private class EncryptedElement {
        private Element element;
        private boolean contentOnly;

        public EncryptedElement(Element element, boolean contentOnly) {
            this.element = element;
            this.contentOnly = contentOnly;
        }

        public Element getElement() {
            return this.element;
        }

        public boolean getContentOnly() {
            return this.contentOnly;
        }

        public boolean equals(Object element) {
            if (element instanceof EncryptedElement) {
                EncryptedElement encryptedElement = (EncryptedElement)element;
                return encryptedElement.getElement() == this.element && encryptedElement.getContentOnly() == this.contentOnly;
            }
            return false;
        }
    }
}

