/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SamlAssertionHeaderBlock;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.saml.assertion.Advice;
import com.sun.xml.wss.saml.assertion.Assertion;
import com.sun.xml.wss.saml.assertion.Conditions;
import com.sun.xml.wss.saml.common.SAMLException;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;

public class CreateSamlAssertionFilter
extends FilterBase
implements MessageFilter {
    private Assertion assertion_ = null;

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        String wsuId = secureMessage.generateId();
        SamlAssertionHeaderBlock token = new SamlAssertionHeaderBlock(this.assertion_);
        secureMessage.setFilterParameter("TokenId", wsuId);
    }

    public CreateSamlAssertionFilter(Assertion assertion) throws XWSSecurityException {
        if (null == assertion) {
            log.log(Level.SEVERE, "");
            throw new XWSSecurityException("");
        }
        this.assertion_ = assertion;
    }

    public CreateSamlAssertionFilter(String assertionId, String issuer, Date issueInstant, Conditions conditions, Advice advice, Set statements) throws XWSSecurityException {
        try {
            this.assertion_ = new Assertion(assertionId, issuer, issueInstant, conditions, advice, statements);
        }
        catch (SAMLException e) {
            log.log(Level.SEVERE, "");
            throw new XWSSecurityException(e);
        }
    }

    public CreateSamlAssertionFilter(String assertionId, String issuer, Date issueInstant, Conditions conditions, Set statements) throws XWSSecurityException {
        try {
            this.assertion_ = new Assertion(assertionId, issuer, issueInstant, conditions, statements);
        }
        catch (SAMLException e) {
            log.log(Level.SEVERE, "");
            throw new XWSSecurityException(e);
        }
    }

    public CreateSamlAssertionFilter(String assertionId, String issuer, Date issueInstant, Set statements) throws XWSSecurityException {
        try {
            this.assertion_ = new Assertion(assertionId, issuer, issueInstant, statements);
        }
        catch (SAMLException e) {
            log.log(Level.SEVERE, "");
            throw new XWSSecurityException(e);
        }
    }

    public String getParameter(String name) {
        return super.getParameter(name);
    }

    public void init() throws XWSSecurityException {
        super.init();
    }

    public void setParameter(String name, String value) {
        super.setParameter(name, value);
    }
}

