/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.configuration;

import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import com.sun.xml.wss.configuration.ConfigurationConstants;
import com.sun.xml.wss.configuration.FilterInfo;
import com.sun.xml.wss.configuration.SecurityConfiguration;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SecurityConfigurationXmlWriter
implements ConfigurationConstants {
    public static String writeToString(SecurityConfiguration configuration) throws Exception {
        DocumentBuilderFactoryImpl builderFactory = new DocumentBuilderFactoryImpl();
        builderFactory.setNamespaceAware(true);
        Document configurationDocument = ((DocumentBuilderFactory)builderFactory).newDocumentBuilder().newDocument();
        SecurityConfigurationXmlWriter.doWriteFragmentToString(configuration, configurationDocument);
        DOMSource configurationSource = new DOMSource(configurationDocument.getDocumentElement());
        Transformer transformer = new TransformerFactoryImpl().newTransformer(configurationSource);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        transformer.transform(configurationSource, result);
        return ((Object)stringWriter).toString();
    }

    protected static void doWriteFragmentToString(SecurityConfiguration configuration, Node configurationParent) throws Exception {
        Element configurationRoot = SecurityConfigurationXmlWriter.createChildElement(configurationParent, "RawSecurityConfiguration");
        SecurityConfigurationXmlWriter.writeAnnotator(configurationRoot, configuration);
        SecurityConfigurationXmlWriter.writeRecipient(configurationRoot, configuration);
    }

    protected static void writeAnnotator(Element configurationRoot, SecurityConfiguration configuration) throws Exception {
        if (!configuration.hasAnnotator()) {
            return;
        }
        Element annotatorElement = SecurityConfigurationXmlWriter.createChildElement(configurationRoot, "Annotator");
        SecurityConfigurationXmlWriter.writeFilters(annotatorElement, configuration.getAnnotatorFilters().iterator());
    }

    protected static void writeRecipient(Element configurationRoot, SecurityConfiguration configuration) throws Exception {
        if (!configuration.hasRecipient()) {
            return;
        }
        Element recipientElement = SecurityConfigurationXmlWriter.createChildElement(configurationRoot, "Recipient");
        SecurityConfigurationXmlWriter.writeFilters(recipientElement, configuration.getRecipientFilters().iterator());
    }

    protected static void writeFilters(Element filterParent, Iterator eachFilter) throws Exception {
        while (eachFilter.hasNext()) {
            FilterInfo filterInfo = (FilterInfo)eachFilter.next();
            Element filterElement = SecurityConfigurationXmlWriter.createChildElement(filterParent, "Filter");
            filterElement.setAttribute("className", filterInfo.getTypeName());
        }
    }

    protected static Element createChildElement(Node node, String localName) {
        Document configurationDocument = node.getOwnerDocument();
        Element configurationRoot = configurationDocument.createElementNS("http://java.sun.com/xml/ns/xwss/config", "xwss:" + localName);
        configurationDocument.appendChild(configurationRoot);
        return configurationRoot;
    }
}

