/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.configuration;

import com.sun.xml.wss.FilterCollection;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurityAnnotator;
import com.sun.xml.wss.SecurityRecipient;
import com.sun.xml.wss.configuration.FilterInfo;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecurityConfiguration {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    protected boolean createAnnotator = false;
    protected boolean createRecipient = false;
    protected List annotatorFilters = null;
    protected List recipientFilters = null;
    protected boolean createProperties = false;
    protected Properties properties = null;

    public SecurityConfiguration(SecurityAnnotator annotator) {
        this(annotator, null);
    }

    public SecurityConfiguration(SecurityRecipient recipient) {
        this(null, recipient);
    }

    public SecurityConfiguration(SecurityAnnotator annotator, SecurityRecipient recipient) {
        if (annotator != null) {
            this.createAnnotator = true;
            this.annotatorFilters = this.recordFilters(annotator.getFilters());
        }
        if (recipient != null) {
            this.createRecipient = true;
            this.recipientFilters = this.recordFilters(recipient.getFilters());
        }
    }

    public SecurityConfiguration() {
    }

    private List recordFilters(Iterator eachFilter) {
        ArrayList<FilterInfo> filters = new ArrayList<FilterInfo>();
        while (eachFilter.hasNext()) {
            MessageFilter filter = (MessageFilter)eachFilter.next();
            filters.add(new FilterInfo(filter));
        }
        return filters;
    }

    public SecurityAnnotator createAnnotator() throws Exception {
        if (!this.createAnnotator) {
            return null;
        }
        SecurityAnnotator createdAnnotator = new SecurityAnnotator();
        this.createFilters(createdAnnotator, this.annotatorFilters);
        return createdAnnotator;
    }

    public SecurityRecipient createRecipient() throws Exception {
        if (!this.createRecipient) {
            return null;
        }
        SecurityRecipient createdRecipient = new SecurityRecipient();
        this.createFilters(createdRecipient, this.recipientFilters);
        return createdRecipient;
    }

    protected void createFilters(FilterCollection filterCollection, List filters) throws Exception {
        Iterator eachFilter = filters.iterator();
        while (eachFilter.hasNext()) {
            FilterInfo filterInfo = (FilterInfo)eachFilter.next();
            filterCollection.addFilter(filterInfo.createFilter());
        }
    }

    public boolean hasAnnotator() {
        return this.createAnnotator;
    }

    public boolean hasRecipient() {
        return this.createRecipient;
    }

    public void setHasAnnotator() {
        this.createAnnotator = true;
        this.annotatorFilters = new ArrayList();
    }

    public void setHasRecipient() {
        this.createRecipient = true;
        this.recipientFilters = new ArrayList();
    }

    public List getAnnotatorFilters() {
        return this.annotatorFilters;
    }

    public List getRecipientFilters() {
        return this.recipientFilters;
    }

    public boolean hasProperties() {
        return this.createProperties;
    }

    public void setHasProperties() {
        this.createProperties = true;
        this.properties = new Properties();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        String propertyValue = this.properties.getProperty(key);
        if (propertyValue == null && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WSS0501.property.not.defined", key);
        }
        return propertyValue;
    }

    public Enumeration getPropertyNames() {
        return this.properties.propertyNames();
    }
}

