/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.configuration;

import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.configuration.StrategyInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilterInfo {
    protected Class filterType;
    protected static final String DEFAULT_PACKAGE_FILTER = "com.sun.xml.wss.filter.";
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    protected HashMap filterInitializationParameters = new HashMap();
    protected StrategyInfo strategyParameter = null;
    protected ArrayList targets = null;

    public FilterInfo(MessageFilter filter) {
        this.filterType = filter.getClass();
    }

    public FilterInfo(String className) {
        this.setTypeName(className);
    }

    public FilterInfo() {
    }

    public void setTypeName(String className) {
        String fullClassName = this.expandClassName(className);
        try {
            this.filterType = Class.forName(fullClassName);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.SEVERE, "WSS0400.class.not.messagefilter", fullClassName);
            throw new IllegalArgumentException("Error: " + fullClassName + " is not a recognized class name");
        }
        if (!MessageFilter.class.isAssignableFrom(this.filterType)) {
            log.log(Level.SEVERE, "WSS0400.class.not.messagefilter", fullClassName);
            throw new IllegalArgumentException("Error: " + fullClassName + " does not implement MessageFilter");
        }
    }

    private String expandClassName(String className) {
        int dotLocation = className.indexOf(46);
        if (dotLocation >= 0) {
            return className;
        }
        return DEFAULT_PACKAGE_FILTER + className;
    }

    public MessageFilter createFilter() throws Exception {
        MessageFilter mfilter = (MessageFilter)this.filterType.newInstance();
        Iterator enum1 = this.getInitializationParameterNames();
        while (enum1.hasNext()) {
            String parameterName = (String)enum1.next();
            String parameterValue = this.getInitializationParameter(parameterName);
            mfilter.setParameter(parameterName, parameterValue);
        }
        if (this.strategyParameter != null) {
            mfilter.setKeyInfoStrategyParameter(this.strategyParameter.createStrategy());
        }
        mfilter.setTargetList(this.targets);
        mfilter.init();
        return mfilter;
    }

    public String getTypeName() {
        String typeName = this.filterType.getName();
        if (typeName.startsWith(DEFAULT_PACKAGE_FILTER)) {
            typeName = typeName.substring(DEFAULT_PACKAGE_FILTER.length());
        }
        return typeName;
    }

    public void setInitializationParameter(String paramName, String paramValue) {
        this.filterInitializationParameters.put(paramName, paramValue);
    }

    public String getInitializationParameter(String paramName) {
        return (String)this.filterInitializationParameters.get(paramName);
    }

    public HashMap getInitializationParameters() {
        return this.filterInitializationParameters;
    }

    public Iterator getInitializationParameterNames() {
        return this.filterInitializationParameters.keySet().iterator();
    }

    public void setKeyInfoStrategyParameter(StrategyInfo info) {
        this.strategyParameter = info;
    }

    public void setTargetList(ArrayList targets) {
        this.targets = targets;
    }
}

