/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.configuration;

import com.sun.xml.wss.configuration.ConfigurationBuilder;
import com.sun.xml.wss.configuration.DefaultSettings;
import com.sun.xml.wss.configuration.SecurityConfiguration;
import com.sun.xml.wss.configuration.SecurityOperations;
import com.sun.xml.wss.configuration.SecurityRequirements;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeclarativeSecurityConfiguration {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    protected SecurityOperations senderSettings = new SecurityOperations();
    protected SecurityRequirements receiverSettings = new SecurityRequirements();
    protected boolean usingDefaults = false;
    protected boolean notUsingDefaults = false;
    protected DefaultSettings defaults = null;

    public void setUseTimestamps(boolean doUseTimestamps) {
        if (doUseTimestamps) {
            this.senderSettings.doTimestamp();
        }
    }

    public void setRequireTimestamps(boolean doRequireTimestamps) {
        if (doRequireTimestamps) {
            this.receiverSettings.requireTimestamp();
        }
    }

    public void setAuthorizeLocally(boolean doAuthorizeLocally) {
        if (doAuthorizeLocally) {
            this.receiverSettings.authorize();
        }
    }

    public void setDumpMessages(boolean doDumpMessages) {
        if (doDumpMessages) {
            this.senderSettings.dumpMessages();
            this.receiverSettings.dumpMessages();
        }
    }

    public void setDefaults(DefaultSettings defaults) {
        if (this.notUsingDefaults) {
            log.log(Level.SEVERE, "WSS0508.unableto.set.defaults");
            throw new IllegalStateException("Defaults cannot be used aftercustom settings have been added.");
        }
        if (this.usingDefaults) {
            throw new IllegalStateException("Only one default can be used");
        }
        defaults.setUp(this.senderSettings, this.receiverSettings);
        this.defaults = defaults;
        this.usingDefaults = true;
    }

    public SecurityOperations senderSettings() {
        if (this.usingDefaults) {
            log.log(Level.SEVERE, "WSS0509.defaults.already.set");
            throw new IllegalStateException("Custom settings cannot be used afterDefaults settings have been added.");
        }
        this.notUsingDefaults = true;
        return this.senderSettings;
    }

    public SecurityRequirements receiverSettings() {
        this.notUsingDefaults = true;
        return this.receiverSettings;
    }

    public SecurityConfiguration createConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder(this);
        return builder.buildConfiguration();
    }
}

