/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.configuration;

import com.sun.xml.wss.Target;
import com.sun.xml.wss.configuration.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.configuration.DirectReferenceStrategyInfo;
import com.sun.xml.wss.configuration.EncryptOperation;
import com.sun.xml.wss.configuration.ExtendedFilterInfo;
import com.sun.xml.wss.configuration.FilterInfo;
import com.sun.xml.wss.configuration.NameStrategyInfo;
import com.sun.xml.wss.configuration.SecurityConfiguration;
import com.sun.xml.wss.configuration.SecurityOperation;
import com.sun.xml.wss.configuration.SignOperation;
import com.sun.xml.wss.configuration.StrategyInfo;
import com.sun.xml.wss.configuration.UsernamePasswordOperation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConfigurationBuilder {
    private DeclarativeSecurityConfiguration configurationData;
    private List filters = new ArrayList();

    public ConfigurationBuilder(DeclarativeSecurityConfiguration configurationData) {
        this.configurationData = configurationData;
    }

    public SecurityConfiguration buildConfiguration() {
        SecurityConfiguration configuration = new SecurityConfiguration();
        this.aggregateConfigurationData();
        this.finalBuild(configuration);
        return configuration;
    }

    private void aggregateConfigurationData() {
        Iterator eachOperation = this.configurationData.senderSettings().iterator();
        while (eachOperation.hasNext()) {
            SecurityOperation operation = (SecurityOperation)eachOperation.next();
            operation.contributeTo(this);
        }
    }

    private void finalBuild(SecurityConfiguration configuration) {
        FilterInfo filter;
        if (this.needsSenderFilters()) {
            configuration.setHasAnnotator();
            List senderFilters = configuration.getAnnotatorFilters();
            if (this.configurationData.senderSettings().isUsingTimestamps()) {
                filter = new FilterInfo("ExportTimestampFilter");
                filter.setInitializationParameter("timeout", this.configurationData.senderSettings().getTimeout());
                senderFilters.add(filter);
            }
            Iterator eachFilterInfo = this.filters.iterator();
            while (eachFilterInfo.hasNext()) {
                FilterInfo currentFilter = (FilterInfo)eachFilterInfo.next();
                senderFilters.add(currentFilter);
            }
            if (this.configurationData.senderSettings().isDumpingMessages()) {
                FilterInfo filter2 = new FilterInfo("DumpFilter");
                filter2.setInitializationParameter("requestorresponse", "Sending Message");
                senderFilters.add(filter2);
            }
        }
        configuration.setHasRecipient();
        List recipientFilters = configuration.getRecipientFilters();
        if (this.configurationData.receiverSettings().isDumpingMessages()) {
            filter = new FilterInfo("DumpFilter");
            filter.setInitializationParameter("requestorresponse", "Received Message");
            recipientFilters.add(filter);
        }
        if (this.configurationData.receiverSettings() != null && !this.configurationData.receiverSettings().isEmpty()) {
            ExtendedFilterInfo extendedFilterInfo = new ExtendedFilterInfo("ExtendedProcessSecurityHeaderFilter");
            extendedFilterInfo.setReceiverRequirements(this.configurationData.receiverSettings());
            recipientFilters.add(extendedFilterInfo);
        }
    }

    private boolean needsSenderFilters() {
        return this.configurationData.senderSettings().isDumpingMessages() || !this.filters.isEmpty();
    }

    public void addEncryption(EncryptOperation operation) {
        StrategyInfo keyStrategy = operation.getKeyStrategy();
        if (keyStrategy instanceof NameStrategyInfo) {
            keyStrategy.setInitializationParameter("alias", operation.getSessionKeyAlias());
        } else {
            keyStrategy.setInitializationParameter("alias", operation.getCertificateAlias());
        }
        keyStrategy.setInitializationParameter("forsigning", "false");
        if (keyStrategy instanceof NameStrategyInfo) {
            FilterInfo filter1 = new FilterInfo("ExportReferenceListFilter");
            this.filters.add(filter1);
            FilterInfo filter2 = new FilterInfo("EncryptElementFilter");
            filter2.setKeyInfoStrategyParameter(keyStrategy);
            filter2.setTargetList(operation.getTargets());
            this.filters.add(filter2);
        } else {
            FilterInfo filter1 = new FilterInfo("ExportEncryptedKeyFilter");
            filter1.setInitializationParameter("keyEncryptionAlgorithm", operation.getKeyEncryptionAlgorithm());
            String x509TokenId = operation.getX509TokenId();
            if (x509TokenId != null) {
                filter1.setInitializationParameter("x509TokenId", x509TokenId);
            }
            filter1.setKeyInfoStrategyParameter(keyStrategy);
            this.filters.add(filter1);
            if (keyStrategy instanceof DirectReferenceStrategyInfo) {
                FilterInfo filter2 = new FilterInfo("ExportCertificateTokenFilter");
                this.filters.add(filter2);
            }
            FilterInfo filter3 = new FilterInfo("EncryptElementFilter");
            filter3.setTargetList(operation.getTargets());
            this.filters.add(filter3);
        }
    }

    public void addSignature(SignOperation operation) {
        StrategyInfo keyStrategy = operation.getKeyStrategy();
        keyStrategy.setInitializationParameter("alias", operation.getCertificateAlias());
        keyStrategy.setInitializationParameter("forsigning", "true");
        String strXpath = operation.getStrXpath();
        if (strXpath == null) {
            this.addSignFilter(operation, strXpath, "true", keyStrategy);
            if (keyStrategy instanceof DirectReferenceStrategyInfo) {
                this.addExportCertificateTokenFilter();
            }
        } else {
            this.addExportSignatureFilter(operation, keyStrategy);
            if (keyStrategy instanceof DirectReferenceStrategyInfo) {
                this.addExportCertificateTokenFilter();
            }
            this.addSignFilter(operation, strXpath, "false", null);
        }
    }

    private void addSignFilter(SignOperation operation, String strXpath, String exportsigblock, StrategyInfo keyStrategy) {
        String x509TokenId;
        FilterInfo filter = new FilterInfo("SignFilter");
        filter.setTargetList(operation.getTargets());
        filter.setInitializationParameter("exportsigblock", exportsigblock);
        filter.setInitializationParameter("strtransformxpath", strXpath);
        filter.setKeyInfoStrategyParameter(keyStrategy);
        if (keyStrategy != null && (x509TokenId = operation.getX509TokenId()) != null) {
            filter.setInitializationParameter("x509TokenId", x509TokenId);
        }
        this.filters.add(filter);
    }

    private void addExportCertificateTokenFilter() {
        FilterInfo filter = new FilterInfo("ExportCertificateTokenFilter");
        this.filters.add(filter);
    }

    private void addExportSignatureFilter(SignOperation operation, StrategyInfo keyStrategy) {
        FilterInfo filter = new FilterInfo("ExportSignatureFilter");
        filter.setKeyInfoStrategyParameter(keyStrategy);
        String x509TokenId = operation.getX509TokenId();
        if (x509TokenId != null) {
            filter.setInitializationParameter("x509TokenId", x509TokenId);
        }
        this.filters.add(filter);
    }

    public void addPasswordAuthentication(UsernamePasswordOperation operation) {
        FilterInfo filter = new FilterInfo("ExportUsernameTokenFilter");
        filter.setInitializationParameter("wsuId", operation.getTokenId());
        filter.setInitializationParameter("username", operation.getUsername());
        filter.setInitializationParameter("password", operation.getPassword());
        filter.setInitializationParameter("gennonceandcreated", operation.getUseNonce());
        filter.setInitializationParameter("digestpassword", operation.getDigestPassword());
        this.filters.add(filter);
        if (operation.isEncryptToken()) {
            EncryptOperation passwordEncryptor = new EncryptOperation();
            Target target = new Target();
            target.setType("qname");
            target.setValue("{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd}UsernameToken");
            passwordEncryptor.addTarget(target);
            this.addEncryption(passwordEncryptor);
        }
    }
}

