/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.ReferenceElement;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeaderBlock;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.SecurityHeaderBlockImpl;
import com.sun.xml.wss.reference.DirectReference;
import com.sun.xml.wss.reference.KeyIdentifier;
import com.sun.xml.wss.reference.X509IssuerSerial;
import com.sun.xml.wss.reference.X509SubjectKeyIdentifier;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;

public class SecurityTokenReference
extends SecurityHeaderBlockImpl {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    private ReferenceElement refElement;

    public SecurityTokenReference() throws XWSSecurityException {
        try {
            this.setSOAPElement(SecurityTokenReference.getSoapFactory().createElement("SecurityTokenReference", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"));
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0377.error.creating.str", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    public SecurityTokenReference(Document doc) throws XWSSecurityException {
        try {
            this.setSOAPElement((SOAPElement)doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference"));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0378.error.creating.str", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    public SecurityTokenReference(SOAPElement element) throws XWSSecurityException {
        super(element);
        if (!element.getLocalName().equals("SecurityTokenReference") || !XMLUtil.inWsseNS(element)) {
            log.log(Level.SEVERE, "WSS0379.error.creating.str", element.getTagName());
            throw new XWSSecurityException("Invalid tokenRef passed");
        }
        Iterator eachChild = this.getChildElements();
        Node node = null;
        while (!(node instanceof SOAPElement) && eachChild.hasNext()) {
            node = (Node)eachChild.next();
        }
        if (!(node instanceof SOAPElement)) {
            log.log(Level.SEVERE, "WSS0379.error.creating.str");
            throw new XWSSecurityException("Passed tokenReference does not contain a refElement");
        }
        this.refElement = this.getReferenceElementfromSoapElement((SOAPElement)node);
    }

    public ReferenceElement getReference() {
        return this.refElement;
    }

    public void setReference(ReferenceElement referenceElement) throws XWSSecurityException {
        if (this.refElement != null) {
            log.log(Level.SEVERE, "WSS0380.error.setting.reference");
            throw new XWSSecurityException("Reference element is already present");
        }
        try {
            this.addTextNode("\n");
            this.addChildElement(referenceElement.getAsSoapElement());
            this.addTextNode("\n");
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0381.error.setting.reference");
            throw new XWSSecurityException(e);
        }
        this.refElement = referenceElement;
    }

    public void setWsuId(String wsuId) {
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        this.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", wsuId);
    }

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, SecurityTokenReference.class);
    }

    private ReferenceElement getReferenceElementfromSoapElement(SOAPElement element) throws XWSSecurityException {
        String name = element.getLocalName();
        if (name.equals("KeyIdentifier")) {
            return this.getKeyIdentifier(element);
        }
        if (name.equals("Reference")) {
            return new DirectReference(element);
        }
        if (name.equals("X509Data")) {
            return new X509IssuerSerial(element);
        }
        log.log(Level.SEVERE, "WSS0335.unsupported.referencetype");
        XWSSecurityException xwsse = new XWSSecurityException(element.getTagName() + " key reference type is not supported");
        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
    }

    private KeyIdentifier getKeyIdentifier(SOAPElement element) throws XWSSecurityException {
        if (element.getAttribute("ValueType").equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier")) {
            return new X509SubjectKeyIdentifier(element);
        }
        log.log(Level.SEVERE, "WSS0334.unsupported.keyidentifier");
        throw new XWSSecurityException("unsupported KeyIdentifier Reference Type encountered");
    }
}

