/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.soap.ProcessingContext;
import com.sun.xml.soap.ProcessingStates;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.XWSSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SecureCorrespondent {
    protected List filters = Collections.synchronizedList(new ArrayList());

    public void addFilter(MessageFilter filter) {
        this.filters.add(filter);
    }

    public void prependFilter(MessageFilter filter) {
        this.filters.add(0, filter);
    }

    public void filterMessage(SecurableSoapMessage message) throws XWSSecurityException {
        Iterator eachFilter = this.filters.iterator();
        while (eachFilter.hasNext()) {
            MessageFilter filter = (MessageFilter)eachFilter.next();
            filter.process(message);
            if (!message.isInFaultState()) continue;
            return;
        }
    }

    public void filterMessageInContext(ProcessingContext context) throws XWSSecurityException {
        SecurableSoapMessage message = (SecurableSoapMessage)((Object)context.getProperty("com.sun.xml.soap.SOAPProcessor.Message"));
        this.filterMessage(message);
        if (message.isInFaultState()) {
            context.setProperty("com.sun.xml.soap.SOAPProcessor.State", (Object)ProcessingStates.FAULT);
        }
    }

    public Iterator getFilters() {
        return Collections.unmodifiableList(this.filters).iterator();
    }
}

