/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.org.apache.xml.security.keys.KeyInfo;
import com.sun.org.apache.xml.security.transforms.Transforms;
import com.sun.org.apache.xml.security.utils.resolver.ResourceResolver;
import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeaderBlock;
import com.sun.xml.wss.SecurityToken;
import com.sun.xml.wss.SignatureHeaderBlock;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.helpers.ResolverId;
import com.sun.xml.wss.impl.SecurityHeaderBlockImpl;
import com.sun.xml.wss.saml.assertion.Advice;
import com.sun.xml.wss.saml.assertion.Assertion;
import com.sun.xml.wss.saml.assertion.Conditions;
import com.sun.xml.wss.saml.assertion.Statement;
import com.sun.xml.wss.saml.assertion.Subject;
import com.sun.xml.wss.saml.assertion.SubjectConfirmation;
import com.sun.xml.wss.saml.assertion.SubjectStatement;
import com.sun.xml.wss.saml.common.SAMLException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SamlAssertionHeaderBlock
extends SecurityHeaderBlockImpl
implements SecurityToken {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    private Document contextDocument_ = null;
    private Assertion delegateAssertion_ = null;
    private String wsuId_ = null;

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, SamlAssertionHeaderBlock.class);
    }

    public SamlAssertionHeaderBlock(Assertion assertion) throws XWSSecurityException {
        if (null == assertion) {
            throw new XWSSecurityException("Assertion may not be null.");
        }
        this.delegateAssertion_ = assertion;
    }

    public SamlAssertionHeaderBlock(SOAPElement element) throws XWSSecurityException {
        this.contextDocument_ = element.getOwnerDocument();
        try {
            this.delegateAssertion_ = new Assertion((Element)element);
        }
        catch (SAMLException e) {
            throw new XWSSecurityException(e);
        }
        this.setSOAPElement(element);
    }

    public SamlAssertionHeaderBlock(String assertionID, String issuer, Date issueInstant, Conditions conditions, Advice advice, Set statements) throws XWSSecurityException {
        try {
            this.delegateAssertion_ = new Assertion(assertionID, issuer, issueInstant, conditions, advice, statements);
        }
        catch (SAMLException e) {
            throw new XWSSecurityException(e);
        }
    }

    public SamlAssertionHeaderBlock(String assertionID, String issuer, Date issueInstant, Conditions conditions, Set statements) throws XWSSecurityException {
        try {
            this.delegateAssertion_ = new Assertion(assertionID, issuer, issueInstant, conditions, statements);
        }
        catch (SAMLException e) {
            throw new XWSSecurityException(e);
        }
    }

    public SamlAssertionHeaderBlock(String assertionID, String issuer, Date issueInstant, Set statements) throws XWSSecurityException {
        try {
            this.delegateAssertion_ = new Assertion(assertionID, issuer, issueInstant, statements);
        }
        catch (SAMLException e) {
            throw new XWSSecurityException(e);
        }
    }

    public boolean addStatement(Statement statement) {
        return this.delegateAssertion_.addStatement(statement);
    }

    private SOAPElement convertToSoapElement() throws XWSSecurityException {
        return null;
    }

    public Advice getAdvice() {
        return this.delegateAssertion_.getAdvice();
    }

    public String getAssertionID() {
        return this.delegateAssertion_.getAssertionID();
    }

    public SOAPElement getAsSoapElement() throws XWSSecurityException {
        if (null == this.contextDocument_) {
            try {
                this.contextDocument_ = XMLUtil.newDocument();
            }
            catch (ParserConfigurationException e) {
                throw new XWSSecurityException(e);
            }
        }
        try {
            this.setSOAPElement((SOAPElement)this.delegateAssertion_.toElement(this.contextDocument_, this.delegateAssertion_.getMinorVersion() == 0 ? (short)0 : 1));
        }
        catch (SAMLException e) {
            throw new XWSSecurityException(e);
        }
        return super.getAsSoapElement();
    }

    public Conditions getConditions() {
        return this.delegateAssertion_.getConditions();
    }

    public Document getContextDocument() {
        return this.contextDocument_;
    }

    public Assertion getDelegateAssertion() {
        return this.delegateAssertion_;
    }

    public Date getIssueInstant() {
        return this.delegateAssertion_.getIssueInstant();
    }

    public String getIssuer() {
        return this.delegateAssertion_.getIssuer();
    }

    public int getMajorVersion() {
        return this.delegateAssertion_.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.delegateAssertion_.getMinorVersion();
    }

    public Element getSignature() {
        return this.delegateAssertion_.getSignature();
    }

    public Set getStatement() {
        return this.delegateAssertion_.getStatement();
    }

    public boolean isSignatureValid() {
        return this.delegateAssertion_.isSignatureValid();
    }

    public boolean isSigned() {
        return this.delegateAssertion_.isSigned();
    }

    public boolean isTimeValid() {
        return this.delegateAssertion_.isTimeValid();
    }

    public boolean setAdvice(Advice advice) {
        return this.delegateAssertion_.setAdvice(advice);
    }

    public boolean setConditions(Conditions conditions) {
        return this.delegateAssertion_.setConditions(conditions);
    }

    public void setContextDocument(Document document) {
        this.contextDocument_ = document;
    }

    public void setDelegateAssertion(Assertion assertion) {
        this.delegateAssertion_ = assertion;
    }

    public void setMajorVersion(int majorVersion) {
        this.delegateAssertion_.setMajorVersion(majorVersion);
    }

    public void setMinorVersion(int minorVersion) {
        this.delegateAssertion_.setMinorVersion(minorVersion);
    }

    public boolean setSignature(Element elem) {
        return this.delegateAssertion_.setSignature(elem);
    }

    public String toString() {
        return this.delegateAssertion_.toString();
    }

    public String getWsuId() {
        return this.wsuId_;
    }

    public void setWsuId(String wsuId) {
        this.wsuId_ = wsuId;
    }

    public KeyInfoHeaderBlock getSubjectConfirmationKeyInfo() throws XWSSecurityException {
        Set statements = this.getStatement();
        Iterator it = statements.iterator();
        while (it.hasNext()) {
            SubjectStatement subjStmt;
            Subject subj;
            SubjectConfirmation scf;
            Element keyInfo;
            Object obj = it.next();
            if (!(obj instanceof SubjectStatement) || null == (keyInfo = (scf = (subj = (subjStmt = (SubjectStatement)obj).getSubject()).getSubjectConfirmation()).getKeyInfo())) continue;
            try {
                KeyInfo kinf = new KeyInfo(keyInfo, null);
                return new KeyInfoHeaderBlock(kinf);
            }
            catch (Exception e) {
                throw new XWSSecurityException(e);
            }
        }
        throw new XWSSecurityException("Unable to locate KeyInfo inside SubjectConfirmation of SAML Assertion");
    }

    public SignatureHeaderBlock addSignature(X509Certificate cert, PrivateKey privKey, String algorithm, SecurableSoapMessage secureMessage) throws XWSSecurityException {
        try {
            if (!algorithm.equalsIgnoreCase("RSA")) {
                XWSSecurityException xwse = new XWSSecurityException("Unsupported Sign Algorithm: " + algorithm);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_ALGORITHM, "Unsupported Sign Algorithm: " + algorithm, xwse);
            }
            String signMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            SignatureHeaderBlock sigBlock = new SignatureHeaderBlock(this.contextDocument_, signMethod);
            KeyInfoHeaderBlock keyInfoBlock = sigBlock.getKeyInfoHeaderBlock();
            keyInfoBlock.addX509Data(XMLUtil.getX509Data(this.contextDocument_, cert));
            try {
                Transforms transforms = new Transforms((Document)secureMessage.getSOAPPart());
                transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                String uri = "#" + this.delegateAssertion_.getAssertionID();
                sigBlock.addSignedInfoReference(uri, transforms);
                if (!SecurableSoapMessage.isWsuIdResolverAdded()) {
                    ResourceResolver.registerAtStart(ResolverId.getResolverName());
                    SecurableSoapMessage.setWsuIdResolverAdded(true);
                }
            }
            catch (Exception e) {
                throw new XWSSecurityException(e);
            }
            this.setSignature((Element)sigBlock.getAsSoapElement());
            return sigBlock;
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }
}

