/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.SecurityHeaderBlockImpl;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class EncryptedTypeHeaderBlock
extends SecurityHeaderBlockImpl {
    SOAPElement encryptionMethod;
    KeyInfoHeaderBlock keyInfo;
    SOAPElement cipherData;
    SOAPElement encryptionProperties;
    boolean updateRequired = false;
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");

    public String getId() {
        String id = this.getAttribute("Id");
        if (id.equals("")) {
            return null;
        }
        return id;
    }

    public void setId(String id) {
        this.setAttribute("Id", id);
    }

    public String getType() {
        String type = this.getAttribute("Type");
        if (type.equals("")) {
            return null;
        }
        return type;
    }

    public void setType(String type) {
        this.setAttribute("Type", type);
    }

    public String getMimeType() {
        String mimeType = this.getAttribute("MimeType");
        if (mimeType.equals("")) {
            return null;
        }
        return mimeType;
    }

    public void setMimeType(String mimeType) {
        this.setAttribute("MimeType", mimeType);
    }

    public String getEncoding() {
        String encoding = this.getAttribute("Encoding");
        if (encoding.equals("")) {
            return null;
        }
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.setAttribute("Encoding", encoding);
    }

    public SOAPElement getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public String getEncryptionMethodURI() {
        if (this.encryptionMethod == null) {
            return null;
        }
        return this.encryptionMethod.getAttribute("Algorithm");
    }

    public void setEncryptionMethod(SOAPElement encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
        this.updateRequired = true;
    }

    public void setEncryptionMethod(String algorithmURI) throws XWSSecurityException {
        try {
            this.encryptionMethod = EncryptedTypeHeaderBlock.getSoapFactory().createElement("EncryptionMethod", "xenc", "http://www.w3.org/2001/04/xmlenc#");
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0351.error.setting.encryption.method", e.getMessage());
            throw new XWSSecurityException(e);
        }
        this.encryptionMethod.setAttribute("Algorithm", algorithmURI);
        this.updateRequired = true;
    }

    public KeyInfoHeaderBlock getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(KeyInfoHeaderBlock keyInfo) {
        this.keyInfo = keyInfo;
        this.updateRequired = true;
    }

    public String getCipherValue() throws XWSSecurityException {
        if (this.cipherData == null) {
            log.log(Level.SEVERE, "WSS0347.missing.cipher.data");
            throw new XWSSecurityException("Cipher data has not been set");
        }
        Iterator cipherValues = null;
        try {
            cipherValues = this.cipherData.getChildElements(EncryptedTypeHeaderBlock.getSoapFactory().createName("CipherValue", "xenc", "http://www.w3.org/2001/04/xmlenc#"));
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0352.error.getting.cipherValue", e.getMessage());
            throw new XWSSecurityException(e);
        }
        if (!cipherValues.hasNext()) {
            log.log(Level.SEVERE, "WSS0353.missing.cipherValue");
            throw new XWSSecurityException("Cipher Value not present");
        }
        return this.getFullTextChildrenFromElement((Element)((SOAPElement)cipherValues.next()));
    }

    public SOAPElement getCipherData() {
        return this.cipherData;
    }

    public SOAPElement getEncryptionProperties() {
        return this.encryptionProperties;
    }

    public void setEncryptionProperties(SOAPElement encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
        this.updateRequired = true;
    }

    public void saveChanges() {
        this.updateRequired = true;
    }

    void initializeEncryptedType(SOAPElement element) throws XWSSecurityException {
        try {
            Iterator cipherDatas;
            Iterator keyInfos;
            Iterator encryptionMethods = this.getChildElements(EncryptedTypeHeaderBlock.getSoapFactory().createName("EncryptionMethod", "xenc", "http://www.w3.org/2001/04/xmlenc#"));
            if (encryptionMethods.hasNext()) {
                this.encryptionMethod = (SOAPElement)encryptionMethods.next();
            }
            if ((keyInfos = this.getChildElements(EncryptedTypeHeaderBlock.getSoapFactory().createName("KeyInfo", "ds", "http://www.w3.org/2000/09/xmldsig#"))).hasNext()) {
                this.keyInfo = new KeyInfoHeaderBlock((SOAPElement)keyInfos.next());
            }
            if (!(cipherDatas = this.getChildElements(EncryptedTypeHeaderBlock.getSoapFactory().createName("CipherData", "xenc", "http://www.w3.org/2001/04/xmlenc#"))).hasNext()) {
                log.log(Level.SEVERE, "WSS0347.missing.cipher.data");
                throw new XWSSecurityException("CipherData is not present inside EncryptedType");
            }
            this.cipherData = (SOAPElement)cipherDatas.next();
            Iterator allEncryptionProperties = this.getChildElements(EncryptedTypeHeaderBlock.getSoapFactory().createName("EncryptionProperties", "xenc", "http://www.w3.org/2001/04/xmlenc#"));
            if (allEncryptionProperties.hasNext()) {
                this.encryptionProperties = (SOAPElement)allEncryptionProperties.next();
            }
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0354.error.initializing.encryptedType", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    private String getFullTextChildrenFromElement(Element element) {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        int iMax = children.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node curr = children.item(i);
            if (curr.getNodeType() != 3) continue;
            sb.append(((Text)curr).getData());
        }
        return sb.toString();
    }
}

