/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.org.apache.xml.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.security.utils.Base64;
import com.sun.xml.wss.SecurityToken;
import com.sun.xml.wss.SecurityTokenException;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.SecurityHeaderBlockImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinarySecurityToken
extends SecurityHeaderBlockImpl
implements SecurityToken {
    protected String valueType = null;
    protected String encodingType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    protected String wsuId = null;
    protected String encodedText = null;
    protected Document soapDoc = null;
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");

    BinarySecurityToken(Document document, String wsuId, String valueType) throws SecurityTokenException {
        this.soapDoc = document;
        this.wsuId = wsuId;
        this.setValueType(valueType);
    }

    BinarySecurityToken(SOAPElement binTokenSoapElement) throws SecurityTokenException {
        String encoding;
        String valueType;
        this.setSOAPElement(binTokenSoapElement);
        this.soapDoc = this.getOwnerDocument();
        this.setTextValue(XMLUtil.getFullTextFromChildren((Element)((Object)this)));
        String wsuId = this.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (!"".equals(wsuId)) {
            this.setId(wsuId);
        }
        if (!"".equals(valueType = this.getAttribute("ValueType"))) {
            this.setValueType(valueType);
        }
        if (!"".equals(encoding = this.getAttribute("EncodingType"))) {
            this.setEncodingType(encoding);
        }
    }

    public String getValueType() {
        return this.valueType;
    }

    protected void setValueType(String valueType) {
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType)) {
            log.log(Level.SEVERE, "WSS0342.valtype.invalid");
            throw new RuntimeException("Unsupported value type: " + valueType);
        }
        this.valueType = valueType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    protected void setEncodingType(String encodingType) {
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary".equals(encodingType)) {
            log.log(Level.SEVERE, "WSS0316.enctype.invalid");
            throw new RuntimeException("Encoding type invalid");
        }
        this.encodingType = encodingType;
    }

    public String getId() {
        return this.wsuId;
    }

    protected void setId(String wsuId) {
        this.wsuId = wsuId;
    }

    public byte[] getRawValue() throws SecurityTokenException {
        try {
            return Base64.decode(this.encodedText);
        }
        catch (Base64DecodingException bde) {
            log.log(Level.SEVERE, "WSS0344.error.decoding.bst");
            throw new SecurityTokenException(bde);
        }
    }

    protected void setRawValue(byte[] rawText) {
        this.encodedText = Base64.encode(rawText);
    }

    public String getTextValue() throws XWSSecurityException {
        return this.encodedText;
    }

    protected void setTextValue(String encodedText) {
        this.encodedText = encodedText;
    }

    public SOAPElement getAsSoapElement() throws SecurityTokenException {
        if (null != this.delegateElement) {
            return this.delegateElement;
        }
        try {
            this.setSOAPElement((SOAPElement)this.soapDoc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken"));
            this.addNamespaceDeclaration("wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            if (null != this.valueType) {
                this.setAttribute("ValueType", this.valueType);
            }
            if (this.encodingType != null) {
                this.setAttribute("EncodingType", this.encodingType);
            }
            if (this.wsuId != null) {
                this.setWsuIdAttr((Element)((Object)this), this.wsuId);
            }
            this.addTextNode(this.getTextValue());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0343.error.creating.bst", e.getMessage());
            throw new SecurityTokenException("There was an error in creating the BinarySecurityToken " + e.getMessage());
        }
        return this.delegateElement;
    }
}

