/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;

public final class WebContainerListener
implements ContainerListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static HashSet beforeEvents = new HashSet();
    private static HashSet afterEvents = new HashSet();
    private InvocationManager im;

    public void containerEvent(ContainerEvent event) {
        String type;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "**** ContainerEvent: " + event.getType() + "," + event.getContainer() + "," + event.getData());
        }
        if (beforeEvents.contains(type = event.getType())) {
            this.preInvoke((Context)event.getContainer());
        } else if (afterEvents.contains(type)) {
            this.postInvoke((Context)event.getContainer());
        }
    }

    private void preInvoke(Context ctx) {
        final ClassLoader cl = ctx.getLoader().getClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
        ComponentInvocation inv = new ComponentInvocation();
        inv.instance = null;
        inv.container = ctx;
        try {
            if (this.im == null) {
                this.im = Switch.getSwitch().getInvocationManager();
            }
            this.im.preInvoke(inv);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "web_server.excep_preinvoke_web_cont_listener", ex);
        }
    }

    private void postInvoke(Context ctx) {
        ComponentInvocation inv = new ComponentInvocation();
        inv.instance = null;
        inv.container = ctx;
        try {
            if (this.im == null) {
                this.im = Switch.getSwitch().getInvocationManager();
            }
            this.im.postInvoke(inv);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "web_server.excep_postinvoke_web_cont_listener", ex);
        }
    }

    static {
        beforeEvents.add("beforeContextInitialized");
        beforeEvents.add("beforeContextDestroyed");
        beforeEvents.add("beforeContextAttributeAdded");
        beforeEvents.add("beforeContextAttributeRemoved");
        beforeEvents.add("beforeContextAttributeReplaced");
        beforeEvents.add("beforeSessionCreated");
        beforeEvents.add("beforeSessionDestroyed");
        beforeEvents.add("beforeSessionAttributeAdded");
        beforeEvents.add("beforeSessionAttributeRemoved");
        beforeEvents.add("beforeSessionAttributeReplaced");
        afterEvents.add("afterContextInitialized");
        afterEvents.add("afterContextDestroyed");
        afterEvents.add("afterContextAttributeAdded");
        afterEvents.add("afterContextAttributeRemoved");
        afterEvents.add("afterContextAttributeReplaced");
        afterEvents.add("afterSessionCreated");
        afterEvents.add("afterSessionDestroyed");
        afterEvents.add("afterSessionAttributeAdded");
        afterEvents.add("afterSessionAttributeRemoved");
        afterEvents.add("afterSessionAttributeReplaced");
    }
}

