/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.security.SecurityContext;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import com.sun.web.security.WebPrincipal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transaction;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Realm;

public final class J2EEInstanceListener
implements InstanceListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private InvocationManager im = Switch.getSwitch().getInvocationManager();
    private J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();

    public void instanceEvent(InstanceEvent event) {
        String eventType = event.getType();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "*** InstanceEvent: " + eventType);
        }
        if (eventType.equals("beforeService") || eventType.equals("beforeFilter") || eventType.equals("beforeInit") || eventType.equals("beforeDestroy") || eventType.equals("beforeDispatch")) {
            this.handleBeforeEvent(event, eventType);
        } else if (eventType.equals("afterService") || eventType.equals("afterFilter") || eventType.equals("afterInit") || eventType.equals("afterDestroy") || eventType.equals("afterDispatch")) {
            this.handleAfterEvent(event, eventType);
        }
    }

    private void handleBeforeEvent(InstanceEvent event, String eventType) {
        HttpServletRequest hreq;
        ServletRequest request;
        Object instance = null;
        instance = eventType.equals("beforeFilter") ? event.getFilter() : event.getServlet();
        Context context = (Context)event.getWrapper().getParent();
        final ClassLoader cl = context.getLoader().getClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
        Realm ra = context.getRealm();
        if (ra != null && (request = event.getRequest()) != null && request instanceof HttpServletRequest && (hreq = (HttpServletRequest)request).getUserPrincipal() != null) {
            WebPrincipal prin = (WebPrincipal)hreq.getUserPrincipal();
            SecurityContext.setCurrent(prin.getSecurityContext());
        }
        ComponentInvocation inv = new ComponentInvocation(instance, context);
        try {
            this.im.preInvoke(inv);
            if (eventType.equals("beforeService")) {
                Transaction tran = null;
                tran = this.tm.getTransaction();
                if (tran != null) {
                    inv.setTransaction(tran);
                }
                this.tm.enlistComponentResources();
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "web_server.excep_handle_before_event", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleAfterEvent(InstanceEvent event, String eventType) {
        block23: {
            if (AppVerification.doInstrument() && (eventType.equals("afterService") || eventType.equals("afterInit") || eventType.equals("afterDispatch"))) {
                AppVerification.getInstrumentLogger().doInstrumentForWeb(event);
            }
            Object instance = null;
            instance = eventType.equals("afterFilter") ? event.getFilter() : event.getServlet();
            Context context = (Context)event.getWrapper().getParent();
            ComponentInvocation inv = new ComponentInvocation(instance, context);
            this.im.postInvoke(inv);
            Object var8_6 = null;
            if (eventType.equals("afterDestroy")) {
                this.tm.componentDestroyed(instance);
            }
            if (!eventType.equals("afterFilter") && !eventType.equals("afterService") || this.im.getCurrentInvocation() != null) break block23;
            try {
                Realm ra = context.getRealm();
                if (ra != null && ra instanceof RealmAdapter) {
                    ((RealmAdapter)ra).logout();
                }
            }
            catch (Exception ex2) {
                _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ex2);
            }
            try {
                if (this.tm.getTransaction() != null) {
                    this.tm.rollback();
                }
                break block23;
            }
            catch (Exception ex2) {}
            break block23;
            {
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ex);
                    Object var8_7 = null;
                    if (eventType.equals("afterDestroy")) {
                        this.tm.componentDestroyed(instance);
                    }
                    if (!eventType.equals("afterFilter") && !eventType.equals("afterService") || this.im.getCurrentInvocation() != null) break block23;
                    try {
                        Realm ra = context.getRealm();
                        if (ra != null && ra instanceof RealmAdapter) {
                            ((RealmAdapter)ra).logout();
                        }
                    }
                    catch (Exception ex2) {
                        _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ex2);
                    }
                    try {
                        if (this.tm.getTransaction() != null) {
                            this.tm.rollback();
                        }
                        break block23;
                    }
                    catch (Exception ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (eventType.equals("afterDestroy")) {
                    this.tm.componentDestroyed(instance);
                }
                if ((eventType.equals("afterFilter") || eventType.equals("afterService")) && this.im.getCurrentInvocation() == null) {
                    try {
                        Realm ra = context.getRealm();
                        if (ra != null && ra instanceof RealmAdapter) {
                            ((RealmAdapter)ra).logout();
                        }
                    }
                    catch (Exception ex2) {
                        _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ex2);
                    }
                    try {
                        if (this.tm.getTransaction() != null) {
                            this.tm.rollback();
                        }
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

