/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.logging.LogDomains;
import com.sun.web.security.WebPrincipal;
import com.sun.web.security.WebSecurityManager;
import com.sun.web.security.WebSecurityManagerFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;
import sun.security.x509.X500Name;

public class RealmAdapter
extends RealmBase {
    private static final String UNCONSTRAINED = "unconstrained";
    static Logger _logger;
    public static final String SECURITY_CONTEXT = "SecurityContext";
    public static final String BASIC = "BASIC";
    public static final String FORM = "FORM";
    private static int MAX_COUNT;
    private static int SLEEP_TIME;
    private SecurityRoleMapper mapper = null;
    private WebBundleDescriptor webDesc = null;
    private HashMap runAsPrincipals = null;
    private String _realmName = null;
    protected static final String name = "J2EE-RI-RealmAdapter";
    private String CONTEXT_ID = null;
    protected static StringManager sm;
    protected WebSecurityManager webSecurityManager;
    protected WebSecurityManagerFactory webSecurityManagerFactory = WebSecurityManagerFactory.getInstance();
    protected boolean isCurrentURIincluded = false;
    private HttpServletRequest currentRequest = null;
    private ArrayList roles = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RealmAdapter() {
    }

    public RealmAdapter(WebBundleDescriptor descriptor) {
        this.webDesc = descriptor;
        Application app = descriptor.getApplication();
        this.mapper = app.getRoleMapper();
        LoginConfiguration loginConfig = descriptor.getLoginConfiguration();
        this._realmName = app.getRealm();
        if (this._realmName == null && loginConfig != null) {
            this._realmName = loginConfig.getRealmName();
        }
        this.CONTEXT_ID = WebSecurityManager.getContextID(descriptor);
        this.runAsPrincipals = new HashMap();
        Iterator bundle = this.webDesc.getWebComponentDescriptorsSet().iterator();
        while (bundle.hasNext()) {
            WebComponentDescriptor wcd = (WebComponentDescriptor)bundle.next();
            RunAsIdentityDescriptor runAsDescriptor = wcd.getRunAsIdentity();
            if (runAsDescriptor == null) continue;
            String principal = runAsDescriptor.getPrincipal();
            String servlet = wcd.getCanonicalName();
            if (principal == null || servlet == null) {
                _logger.warning("web.realmadapter.norunas");
                continue;
            }
            this.runAsPrincipals.put(servlet, principal);
            _logger.fine("Servlet " + servlet + " will run-as: " + principal);
        }
    }

    public WebBundleDescriptor getWebDescriptor() {
        return this.webDesc;
    }

    public boolean hasRole(Principal principal, String role) {
        this.webSecurityManager = this.webSecurityManagerFactory.getWebSecurityManager(this.CONTEXT_ID);
        String servletName = this.getResourceName(this.currentRequest.getRequestURI(), this.currentRequest.getContextPath());
        boolean isGranted = this.webSecurityManager.hasRoleRefPermission(servletName, role, principal);
        if (!isGranted) {
            servletName = this.getCanonicalName();
            if (servletName.equalsIgnoreCase(UNCONSTRAINED)) {
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "Unable to find a <servlet-name> element which map: " + this.currentRequest.getRequestURI());
                }
                isGranted = this.webSecurityManager.hasRoleRefPermission("", role, principal);
            } else {
                isGranted = this.webSecurityManager.hasRoleRefPermission(servletName, role, principal);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Checking if servlet " + servletName + " with principal " + principal + " has role " + role + " isGranted: " + isGranted);
        }
        return isGranted;
    }

    public void logout() {
        this.setSecurityContext(null);
    }

    public Principal authenticate(String username, byte[] authData) {
        return this.authenticate(username, new String(authData));
    }

    public Principal authenticate(String username, String password) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Tomcat callback for authenticate user/password");
            _logger.fine("usename = " + username);
        }
        if (this.authenticate(username, password, null)) {
            SecurityContext secCtx = SecurityContext.getCurrent();
            if (!$assertionsDisabled && secCtx == null) {
                throw new AssertionError();
            }
            return new WebPrincipal(username, password, secCtx);
        }
        return null;
    }

    public Principal authenticate(X509Certificate[] certs) {
        if (this.authenticate(null, null, certs)) {
            SecurityContext secCtx = SecurityContext.getCurrent();
            if (!$assertionsDisabled && secCtx == null) {
                throw new AssertionError();
            }
            return new WebPrincipal(certs, secCtx);
        }
        return null;
    }

    public boolean authenticate(WebPrincipal prin) {
        if (prin.isUsingCertificate()) {
            return this.authenticate(null, null, prin.getCertificates());
        }
        return this.authenticate(prin.getName(), prin.getPassword(), null);
    }

    protected boolean authenticate(String username, String password, X509Certificate[] certs) {
        boolean success;
        block5: {
            SecurityContext.setCurrent(null);
            String realm_name = null;
            success = false;
            try {
                if (certs != null) {
                    Subject subject = new Subject();
                    X509Certificate certificate = certs[0];
                    X500Name x500Name = (X500Name)certificate.getSubjectDN();
                    subject.getPublicCredentials().add(x500Name);
                    LoginContextDriver.login(subject, X500Name.class);
                    realm_name = "certificate";
                } else {
                    realm_name = this._realmName;
                    LoginContextDriver.login(username, password, realm_name);
                }
                success = true;
            }
            catch (Exception le) {
                success = false;
                if (!_logger.isLoggable(Level.WARNING)) break block5;
                _logger.warning("Web login failed: " + le.getMessage());
            }
        }
        if (success && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Web login succeeded for: " + username);
        }
        return success;
    }

    public void preSetRunAsIdentity(ComponentInvocation inv) {
        String name = this.getServletName(inv);
        if (name == null) {
            return;
        }
        String runAs = (String)this.runAsPrincipals.get(name);
        if (runAs != null) {
            SecurityContext old = this.getSecurityContext();
            inv.setOldSecurityContext(old);
            this.loginForRunAs(runAs);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("run-as principal for " + name + " set to: " + runAs);
            }
        }
    }

    private String getServletName(ComponentInvocation inv) {
        HttpServlet thisServlet;
        ServletConfig svc;
        Object invInstance = inv.getInstance();
        if (invInstance instanceof HttpServlet && (svc = (thisServlet = (HttpServlet)invInstance).getServletConfig()) != null) {
            return thisServlet.getServletName();
        }
        return null;
    }

    public void postSetRunAsIdentity(ComponentInvocation inv) {
        String name = this.getServletName(inv);
        if (name == null) {
            return;
        }
        String runAs = (String)this.runAsPrincipals.get(name);
        if (runAs != null) {
            this.setSecurityContext(inv.getOldSecurityContext());
        }
    }

    private void loginForRunAs(String principal) {
        LoginContextDriver.loginPrincipal(principal, this._realmName);
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    private void setSecurityContext(SecurityContext sc) {
        SecurityContext.setCurrent(sc);
    }

    protected String getPassword(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    protected Principal getPrincipal(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    public Principal createFailOveredPrincipal(String username) {
        _logger.log(Level.FINEST, "IN createFailOveredPrincipal (" + username + ")");
        this.loginForRunAs(username);
        SecurityContext secCtx = SecurityContext.getCurrent();
        _logger.log(Level.FINE, "Security context is " + secCtx);
        if (!$assertionsDisabled && secCtx == null) {
            throw new AssertionError();
        }
        WebPrincipal principal = new WebPrincipal(username, null, secCtx);
        _logger.log(Level.INFO, "Principal created for FailOvered user " + principal);
        return principal;
    }

    public boolean hasResourcePermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, Context context) throws IOException {
        Principal principal;
        if (constraints == null) {
            return true;
        }
        boolean hasAuthConstraints = false;
        for (int i = 0; i < constraints.length; ++i) {
            if (!constraints[i].getAuthConstraint()) continue;
            hasAuthConstraints = true;
            break;
        }
        if (!hasAuthConstraints) {
            return true;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request;
        if (hrequest.getServletPath() == null) {
            request.setServletPath(this.getResourceName(hrequest.getRequestURI(), hrequest.getContextPath()));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[Web-Security] [ hasResourcePermission ] Principal: " + hrequest.getUserPrincipal() + " ContextPath: " + hrequest.getContextPath());
        }
        this.currentRequest = hrequest;
        LoginConfig config = context.getLoginConfig();
        if (config != null && FORM.equals(config.getAuthMethod())) {
            String requestURI = request.getDecodedRequestURI();
            String loginPage = context.getPath() + config.getLoginPage();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[Web-Security]  requestURI: " + requestURI + " loginPage: " + loginPage);
            }
            if (loginPage.equals(requestURI)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Allow access to login page " + loginPage);
                }
                return true;
            }
            String errorPage = context.getPath() + config.getErrorPage();
            if (errorPage.equals(requestURI)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Allow access to error page " + errorPage);
                }
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Allow access to username/password submission");
                }
                return true;
            }
        }
        if ((principal = hrequest.getUserPrincipal()) == null) {
            ((HttpServletResponse)response.getResponse()).sendError(403, sm.getString("realmBase.notAuthenticated"));
            return false;
        }
        boolean isGranted = this.webSecurityManager.hasResourcePermission(hrequest);
        if (isGranted) {
            return isGranted;
        }
        ((HttpServletResponse)response.getResponse()).sendError(403, sm.getString("realmBase.forbidden"));
        return isGranted;
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        HttpServletRequest hrequest;
        if (constraints == null) {
            return true;
        }
        this.currentRequest = hrequest = (HttpServletRequest)request;
        if (hrequest.getServletPath() == null) {
            request.setServletPath(this.getResourceName(hrequest.getRequestURI(), hrequest.getContextPath()));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[Web-Security][ hasUserDataPermission ] Principal: " + hrequest.getUserPrincipal() + " ContextPath: " + hrequest.getContextPath());
        }
        this.webSecurityManager = this.webSecurityManagerFactory.getWebSecurityManager(this.CONTEXT_ID);
        if (request.getRequest().isSecure()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[Web-Security] request.getRequest().isSecure(): " + request.getRequest().isSecure());
            }
            return true;
        }
        int isGranted = this.webSecurityManager.hasUserDataPermission(hrequest);
        if (isGranted == -1) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[Web-Security] redirecting using SSL");
            }
            return this.redirect(request, response);
        }
        if (isGranted == 0) {
            ((HttpServletResponse)response.getResponse()).sendError(403, sm.getString("realmBase.forbidden"));
            return false;
        }
        return true;
    }

    private boolean redirect(HttpRequest request, HttpResponse response) throws IOException {
        String queryString;
        HttpServletRequest hrequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse hresponse = (HttpServletResponse)response.getResponse();
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.fine("[Web-Security]  SSL redirect is disabled");
            }
            hresponse.sendError(403, hrequest.getRequestURI());
            return false;
        }
        String protocol = "https";
        String host = hrequest.getServerName();
        StringBuffer file = new StringBuffer(hrequest.getRequestURI());
        String requestedSessionId = hrequest.getRequestedSessionId();
        if (requestedSessionId != null && hrequest.isRequestedSessionIdFromURL()) {
            file.append(";jsessionid=");
            file.append(requestedSessionId);
        }
        if ((queryString = hrequest.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        URL url = null;
        try {
            url = new URL(protocol, host, redirectPort, file.toString());
            hresponse.sendRedirect(url.toString());
            return false;
        }
        catch (MalformedURLException e) {
            hresponse.sendError(500, hrequest.getRequestURI());
            return false;
        }
    }

    private String getCanonicalName() {
        String servletUri = "";
        String currentUri = "";
        String aliasUri = "";
        String currentUriExtension = "";
        String aliasUriExtension = "";
        boolean isAliasExists = false;
        Iterator itr = this.webDesc.getWebComponentDescriptorsSet().iterator();
        while (itr.hasNext()) {
            WebComponentDescriptor webComponentDescriptor = (WebComponentDescriptor)itr.next();
            servletUri = webComponentDescriptor.getWebComponentImplementation();
            currentUri = this.getResourceName(this.currentRequest.getRequestURI(), this.currentRequest.getContextPath());
            currentUriExtension = this.getExtension(currentUri);
            Iterator i = webComponentDescriptor.getUrlPatternsSet().iterator();
            while (i.hasNext()) {
                aliasUri = i.next().toString();
                aliasUriExtension = this.getExtension(aliasUri);
                if (aliasUri.equalsIgnoreCase(currentUri)) {
                    isAliasExists = true;
                    break;
                }
                if (!aliasUriExtension.equalsIgnoreCase(currentUriExtension) || !aliasUri.equalsIgnoreCase("*" + aliasUriExtension)) continue;
                isAliasExists = true;
                break;
            }
            if (!currentUri.equalsIgnoreCase(servletUri) && !isAliasExists) continue;
            return webComponentDescriptor.getCanonicalName();
        }
        return UNCONSTRAINED;
    }

    private String getResourceName(String uri, String contextPath) {
        try {
            return uri.substring(contextPath.length());
        }
        catch (Exception ex) {
            return "";
        }
    }

    private String getExtension(String uri) {
        try {
            return uri.substring(uri.lastIndexOf("."));
        }
        catch (Exception ex) {
            return "";
        }
    }

    protected String getName() {
        return name;
    }

    public String getRealmName() {
        return this._realmName;
    }

    public void setRealmName(String realmName) {
    }

    static {
        $assertionsDisabled = !RealmAdapter.class.desiredAssertionStatus();
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        MAX_COUNT = 5;
        SLEEP_TIME = 5000;
        sm = StringManager.getManager("org.apache.catalina.realm");
    }
}

