/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.security.signature;

import com.sun.org.apache.xml.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.security.signature.MissingResourceFailureException;
import com.sun.org.apache.xml.security.signature.Reference;
import com.sun.org.apache.xml.security.signature.ReferenceNotInitializedException;
import com.sun.org.apache.xml.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.security.transforms.Transforms;
import com.sun.org.apache.xml.security.utils.I18n;
import com.sun.org.apache.xml.security.utils.IdResolver;
import com.sun.org.apache.xml.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.security.utils.XMLUtils;
import com.sun.org.apache.xml.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Manifest
extends SignatureElementProxy {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$security$signature$Manifest == null ? (class$com$sun$org$apache$xml$security$signature$Manifest = Manifest.class$("com.sun.org.apache.xml.security.signature.Manifest")) : class$com$sun$org$apache$xml$security$signature$Manifest).getName());
    Vector _references;
    private boolean[] verificationResults = null;
    Vector _signedContents = new Vector();
    HashMap _resolverProperties = new HashMap(10);
    Vector _perManifestResolvers = new Vector();
    static /* synthetic */ Class class$com$sun$org$apache$xml$security$signature$Manifest;

    public Manifest(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._references = new Vector();
    }

    public Manifest(Element element, String string) throws XMLSecurityException {
        super(element, string);
        int n = this.length("http://www.w3.org/2000/09/xmldsig#", "Reference");
        if (n == 0) {
            Object[] objectArray = new Object[]{"Reference", "Manifest"};
            throw new DOMException(4, I18n.translate("xml.WrongContent", objectArray));
        }
        this._references = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this._references.add(null);
        }
    }

    public void addDocument(String string, String string2, Transforms transforms, String string3, String string4, String string5) throws XMLSignatureException {
        if (this._state == 0) {
            Reference reference = new Reference(this._doc, string, string2, this, transforms, string3);
            if (string4 != null) {
                reference.setId(string4);
            }
            if (string5 != null) {
                reference.setType(string5);
            }
            this._references.add(reference);
            this._constructionElement.appendChild(reference.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void generateDigestValues() throws XMLSignatureException, ReferenceNotInitializedException {
        if (this._state == 0) {
            for (int i = 0; i < this.getLength(); ++i) {
                Reference reference = (Reference)this._references.elementAt(i);
                reference.generateDigestValue();
            }
        }
    }

    public int getLength() {
        return this._references.size();
    }

    public Reference item(int n) throws XMLSecurityException {
        if (this._state == 0) {
            return (Reference)this._references.elementAt(n);
        }
        if (this._references.elementAt(n) == null) {
            Element element = super.getChildElementLocalName(n, "http://www.w3.org/2000/09/xmldsig#", "Reference");
            Reference reference = new Reference(element, this._baseURI, this);
            this._references.set(n, reference);
        }
        return (Reference)this._references.elementAt(n);
    }

    public void setId(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public boolean verifyReferences() throws MissingResourceFailureException, XMLSecurityException {
        return this.verifyReferences(false);
    }

    public boolean verifyReferences(boolean bl) throws MissingResourceFailureException, XMLSecurityException {
        log.log(Level.FINE, "verify " + this.length("http://www.w3.org/2000/09/xmldsig#", "Reference") + " References");
        log.log(Level.FINE, "I am " + (bl ? "" : "not") + " requested to follow nested Manifests");
        boolean bl2 = true;
        if (this.length("http://www.w3.org/2000/09/xmldsig#", "Reference") == 0) {
            throw new XMLSecurityException("empty");
        }
        this.verificationResults = new boolean[this.length("http://www.w3.org/2000/09/xmldsig#", "Reference")];
        for (int i = 0; i < this.length("http://www.w3.org/2000/09/xmldsig#", "Reference"); ++i) {
            Object object;
            Reference reference = new Reference(this.getChildElementLocalName(i, "http://www.w3.org/2000/09/xmldsig#", "Reference"), this._baseURI, this);
            this._references.set(i, reference);
            try {
                boolean bl3 = reference.verify();
                this.setVerificationResult(i, bl3);
                if (!bl3) {
                    bl2 = false;
                }
                log.log(Level.FINE, "The Reference has Type " + reference.getType());
                if (!bl2 || !bl || !reference.typeIsReferenceToManifest()) continue;
                log.log(Level.FINE, "We have to follow a nested Manifest");
                try {
                    reference.dereferenceURIandPerformTransforms();
                    object = reference.getTransformsOutput();
                    Set set = ((XMLSignatureInput)object).getNodeSet();
                    Manifest manifest = null;
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Node node = (Node)iterator.next();
                        if (node.getNodeType() != 1 || !((Element)node).getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || !((Element)node).getLocalName().equals("Manifest")) continue;
                        try {
                            manifest = new Manifest((Element)node, ((XMLSignatureInput)object).getSourceURI());
                            break;
                        }
                        catch (XMLSecurityException xMLSecurityException) {
                        }
                    }
                    if (manifest == null) {
                        throw new MissingResourceFailureException("empty", reference);
                    }
                    manifest._perManifestResolvers = this._perManifestResolvers;
                    manifest._resolverProperties = this._resolverProperties;
                    boolean bl4 = manifest.verifyReferences(bl);
                    if (!bl4) {
                        bl2 = false;
                        log.log(Level.INFO, "The nested Manifest was invalid (bad)");
                        continue;
                    }
                    log.log(Level.FINE, "The nested Manifest was valid (good)");
                    continue;
                }
                catch (IOException iOException) {
                    throw new ReferenceNotInitializedException("empty", iOException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new ReferenceNotInitializedException("empty", parserConfigurationException);
                }
                catch (SAXException sAXException) {
                    throw new ReferenceNotInitializedException("empty", sAXException);
                }
            }
            catch (ReferenceNotInitializedException referenceNotInitializedException) {
                object = new Object[]{reference.getURI()};
                throw new MissingResourceFailureException("signature.Verification.Reference.NoInput", (Object[])object, referenceNotInitializedException, reference);
            }
        }
        return bl2;
    }

    private void setVerificationResult(int n, boolean bl) throws XMLSecurityException {
        if (this.verificationResults == null) {
            this.verificationResults = new boolean[this.getLength()];
        }
        this.verificationResults[n] = bl;
    }

    public boolean getVerificationResult(int n) throws XMLSecurityException {
        if (n < 0 || n > this.getLength() - 1) {
            Object[] objectArray = new Object[]{Integer.toString(n), Integer.toString(this.getLength())};
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(I18n.translate("signature.Verification.IndexOutOfBounds", objectArray));
            throw new XMLSecurityException("generic.EmptyMessage", indexOutOfBoundsException);
        }
        if (this.verificationResults == null) {
            try {
                this.verifyReferences();
            }
            catch (Exception exception) {
                throw new XMLSecurityException("generic.EmptyMessage", exception);
            }
        }
        return this.verificationResults[n];
    }

    public void addResourceResolver(ResourceResolver resourceResolver) {
        if (resourceResolver != null) {
            this._perManifestResolvers.add(resourceResolver);
        }
    }

    public void addResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        if (resourceResolverSpi != null) {
            this._perManifestResolvers.add(new ResourceResolver(resourceResolverSpi));
        }
    }

    public void setResolverProperty(String string, String string2) {
        Iterator iterator = this._resolverProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.equals(string)) continue;
            string = string3;
            break;
        }
        this._resolverProperties.put(string, string2);
    }

    public String getResolverProperty(String string) {
        Iterator iterator = this._resolverProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals(string)) continue;
            string = string2;
            break;
        }
        return (String)this._resolverProperties.get(string);
    }

    public byte[] getSignedContentItem(int n) throws XMLSignatureException {
        try {
            return this.getReferencedContentAfterTransformsItem(n).getBytes();
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getReferencedContentBeforeTransformsItem(int n) throws XMLSecurityException {
        return this.item(n).getContentsBeforeTransformation();
    }

    public XMLSignatureInput getReferencedContentAfterTransformsItem(int n) throws XMLSecurityException {
        return this.item(n).getContentsAfterTransformation();
    }

    public int getSignedContentLength() {
        return this.getLength();
    }

    public String getBaseLocalName() {
        return "Manifest";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

