/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class DSAKeyValueResolver
extends KeyResolverSpi {
    private Element _dsaKeyElement = null;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        if (element == null) {
            return false;
        }
        boolean bl = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        boolean bl2 = XMLUtils.elementIsInSignatureSpace(element, "DSAKeyValue");
        if (bl) {
            this._dsaKeyElement = XMLUtils.selectDsNode(element.getFirstChild(), "DSAKeyValue", 0);
            if (this._dsaKeyElement != null) {
                return true;
            }
        } else if (bl2) {
            this._dsaKeyElement = element;
            return true;
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        boolean bl;
        if (!(this._dsaKeyElement != null || (bl = this.engineCanResolve(element, string, storageResolver)) && this._dsaKeyElement != null)) {
            return null;
        }
        try {
            DSAKeyValue dSAKeyValue = new DSAKeyValue(this._dsaKeyElement, string);
            PublicKey publicKey = dSAKeyValue.getPublicKey();
            return publicKey;
        }
        catch (XMLSecurityException xMLSecurityException) {
            return null;
        }
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }
}

