/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.security.keys.keyresolver;

import com.sun.org.apache.xml.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.security.keys.storage.StorageResolver;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class KeyResolver {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$security$keys$keyresolver$KeyResolver == null ? (class$com$sun$org$apache$xml$security$keys$keyresolver$KeyResolver = KeyResolver.class$("com.sun.org.apache.xml.security.keys.keyresolver.KeyResolver")) : class$com$sun$org$apache$xml$security$keys$keyresolver$KeyResolver).getName());
    static boolean _alreadyInitialized = false;
    static Vector _resolverVector = null;
    protected KeyResolverSpi _resolverSpi = null;
    protected StorageResolver _storage = null;
    static /* synthetic */ Class class$com$sun$org$apache$xml$security$keys$keyresolver$KeyResolver;

    private KeyResolver(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (KeyResolverSpi)Class.forName(string).newInstance();
    }

    public static int length() {
        return _resolverVector.size();
    }

    public static KeyResolver item(int n) throws KeyResolverException {
        String string = (String)_resolverVector.elementAt(n);
        KeyResolver keyResolver = null;
        try {
            keyResolver = new KeyResolver(string);
        }
        catch (Exception exception) {
            throw new KeyResolverException("utils.resolver.noClass", exception);
        }
        return keyResolver;
    }

    public static final KeyResolver getInstance(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        for (int i = 0; i < _resolverVector.size(); ++i) {
            String string2 = (String)_resolverVector.elementAt(i);
            KeyResolver keyResolver = null;
            try {
                keyResolver = new KeyResolver(string2);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", objectArray, exception);
            }
            log.log(Level.FINE, "check resolvability by class " + string2);
            if (keyResolver == null || !keyResolver.canResolve(element, string, storageResolver)) continue;
            return keyResolver;
        }
        Object[] objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", objectArray);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new Vector(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string) {
        _resolverVector.add(string);
    }

    public static void registerAtStart(String string) {
        _resolverVector.add(0, string);
    }

    public static PublicKey resolveStatic(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        KeyResolver keyResolver = KeyResolver.getInstance(element, string, storageResolver);
        return keyResolver.resolvePublicKey(element, string, storageResolver);
    }

    public PublicKey resolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return this._resolverSpi.engineResolvePublicKey(element, string, storageResolver);
    }

    public X509Certificate resolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return this._resolverSpi.engineResolveX509Certificate(element, string, storageResolver);
    }

    public SecretKey resolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return this._resolverSpi.engineResolveSecretKey(element, string, storageResolver);
    }

    public void setProperty(String string, String string2) {
        this._resolverSpi.engineSetProperty(string, string2);
    }

    public String getProperty(String string) {
        return this._resolverSpi.engineGetProperty(string);
    }

    public String[] getPropertyKeys() {
        return this._resolverSpi.engineGetPropertyKeys();
    }

    public boolean understandsProperty(String string) {
        return this._resolverSpi.understandsProperty(string);
    }

    public boolean canResolve(Element element, String string, StorageResolver storageResolver) {
        return this._resolverSpi.engineCanResolve(element, string, storageResolver);
    }

    public String resolverClassName() {
        return this._resolverSpi.getClass().getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

