/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.security.encryption;

import com.sun.org.apache.xml.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.security.encryption.CipherData;
import com.sun.org.apache.xml.security.encryption.CipherReference;
import com.sun.org.apache.xml.security.encryption.EncryptedType;
import com.sun.org.apache.xml.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xml.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.security.transforms.TransformationException;
import com.sun.org.apache.xml.security.transforms.Transforms;
import com.sun.org.apache.xml.security.utils.Base64;
import com.sun.org.apache.xml.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.security.utils.resolver.ResourceResolverException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;

public class XMLCipherInput {
    private static Logger logger = Logger.getLogger((class$com$sun$org$apache$xml$security$encryption$XMLCipher == null ? (class$com$sun$org$apache$xml$security$encryption$XMLCipher = XMLCipherInput.class$("com.sun.org.apache.xml.security.encryption.XMLCipher")) : class$com$sun$org$apache$xml$security$encryption$XMLCipher).getName());
    private CipherData _cipherData;
    private int _mode;
    static /* synthetic */ Class class$com$sun$org$apache$xml$security$encryption$XMLCipher;

    public XMLCipherInput(CipherData cipherData) throws XMLEncryptionException {
        this._cipherData = cipherData;
        this._mode = 2;
        if (this._cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public XMLCipherInput(EncryptedType encryptedType) throws XMLEncryptionException {
        this._cipherData = encryptedType == null ? null : encryptedType.getCipherData();
        this._mode = 2;
        if (this._cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public byte[] getBytes() throws XMLEncryptionException {
        if (this._mode == 2) {
            return this.getDecryptBytes();
        }
        return null;
    }

    private byte[] getDecryptBytes() throws XMLEncryptionException {
        String string = null;
        if (this._cipherData.getDataType() == 2) {
            Object object;
            logger.log(Level.FINE, "Found a reference type CipherData");
            CipherReference cipherReference = this._cipherData.getCipherReference();
            Attr attr = cipherReference.getURIAsAttr();
            XMLSignatureInput xMLSignatureInput = null;
            try {
                object = ResourceResolver.getInstance(attr, null);
                xMLSignatureInput = ((ResourceResolver)object).resolve(attr, null);
            }
            catch (ResourceResolverException resourceResolverException) {
                throw new XMLEncryptionException("empty", resourceResolverException);
            }
            catch (XMLSecurityException xMLSecurityException) {
                throw new XMLEncryptionException("empty", xMLSecurityException);
            }
            if (xMLSignatureInput != null) {
                logger.log(Level.FINE, "Managed to resolve URI \"" + cipherReference.getURI() + "\"");
            } else {
                logger.log(Level.FINE, "Failed to resolve URI \"" + cipherReference.getURI() + "\"");
            }
            object = cipherReference.getTransforms();
            if (object != null) {
                logger.log(Level.FINE, "Have transforms in cipher reference");
                try {
                    Transforms transforms = object.getDSTransforms();
                    xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
                }
                catch (TransformationException transformationException) {
                    throw new XMLEncryptionException("empty", transformationException);
                }
            }
            try {
                return xMLSignatureInput.getBytes();
            }
            catch (IOException iOException) {
                throw new XMLEncryptionException("empty", iOException);
            }
            catch (InvalidCanonicalizerException invalidCanonicalizerException) {
                throw new XMLEncryptionException("empty", invalidCanonicalizerException);
            }
            catch (CanonicalizationException canonicalizationException) {
                throw new XMLEncryptionException("empty", canonicalizationException);
            }
        }
        if (this._cipherData.getDataType() != 1) {
            throw new XMLEncryptionException("CipherData.getDataType() returned unexpected value");
        }
        Object object = this._cipherData.getCipherValue();
        string = new String(object.getValue());
        logger.log(Level.FINE, "Encrypted octets:\n" + string);
        object = null;
        try {
            object = Base64.decode(string);
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new XMLEncryptionException("empty", base64DecodingException);
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

