/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.security.algorithms.implementations;

import com.sun.org.apache.xml.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import com.sun.org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.security.utils.HexDump;
import com.sun.org.apache.xml.security.utils.XMLUtils;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class IntegrityHmac
extends SignatureAlgorithmSpi {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$security$algorithms$implementations$IntegrityHmac$IntegrityHmacSHA1 == null ? (class$com$sun$org$apache$xml$security$algorithms$implementations$IntegrityHmac$IntegrityHmacSHA1 = IntegrityHmac.class$("com.sun.org.apache.xml.security.algorithms.implementations.IntegrityHmac$IntegrityHmacSHA1")) : class$com$sun$org$apache$xml$security$algorithms$implementations$IntegrityHmac$IntegrityHmacSHA1).getName());
    private Mac _macAlgorithm = null;
    int _HMACOutputLength = 0;
    static /* synthetic */ Class class$com$sun$org$apache$xml$security$algorithms$implementations$IntegrityHmac$IntegrityHmacSHA1;
    static /* synthetic */ Class class$javax$crypto$SecretKey;

    public abstract String engineGetURI();

    public IntegrityHmac() throws XMLSignatureException {
        String string = JCEMapper.translateURItoJCEID(this.engineGetURI());
        log.log(Level.FINE, "Created IntegrityHmacSHA1 using " + string);
        try {
            this._macAlgorithm = Mac.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("empty");
    }

    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            byte[] byArray2 = this._macAlgorithm.doFinal();
            if (this._HMACOutputLength == 0 || this._HMACOutputLength >= 160) {
                log.log(Level.FINE, "completeResult = " + HexDump.byteArrayToHexString(byArray2));
                log.log(Level.FINE, "signature      = " + HexDump.byteArrayToHexString(byArray));
                return MessageDigestAlgorithm.isEqual(byArray2, byArray);
            }
            log.log(Level.FINE, "completeResult = " + HexDump.byteArrayToHexString(byArray2));
            byte[] byArray3 = IntegrityHmac.reduceBitLength(byArray2, this._HMACOutputLength);
            log.log(Level.FINE, "stripped       = " + HexDump.byteArrayToHexString(byArray3));
            log.log(Level.FINE, "signature      = " + HexDump.byteArrayToHexString(byArray));
            return MessageDigestAlgorithm.isEqual(byArray3, byArray);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof SecretKey)) {
            String string = key.getClass().getName();
            String string2 = (class$javax$crypto$SecretKey == null ? (class$javax$crypto$SecretKey = IntegrityHmac.class$("javax.crypto.SecretKey")) : class$javax$crypto$SecretKey).getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._macAlgorithm.init(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            byte[] byArray = this._macAlgorithm.doFinal();
            if (this._HMACOutputLength == 0 || this._HMACOutputLength >= 160) {
                return byArray;
            }
            return IntegrityHmac.reduceBitLength(byArray, this._HMACOutputLength);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    private static byte[] reduceBitLength(byte[] byArray, int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        byte[] byArray2 = new byte[n2 + (n3 == 0 ? 0 : 1)];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        if (n3 > 0) {
            byte[] byArray3 = new byte[]{0, -128, -64, -32, -16, -8, -4, -2};
            byArray2[n2] = (byte)(byArray[n2] & byArray3[n3]);
        }
        return byArray2;
    }

    protected void engineInitSign(Key key) throws XMLSignatureException {
        if (!(key instanceof SecretKey)) {
            String string = key.getClass().getName();
            String string2 = (class$javax$crypto$SecretKey == null ? (class$javax$crypto$SecretKey = IntegrityHmac.class$("javax.crypto.SecretKey")) : class$javax$crypto$SecretKey).getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._macAlgorithm.init(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        if (!(key instanceof SecretKey)) {
            String string = key.getClass().getName();
            String string2 = (class$javax$crypto$SecretKey == null ? (class$javax$crypto$SecretKey = IntegrityHmac.class$("javax.crypto.SecretKey")) : class$javax$crypto$SecretKey).getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._macAlgorithm.init(key, algorithmParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException("empty", invalidAlgorithmParameterException);
        }
    }

    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseSecureRandomOnMAC");
    }

    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(byArray);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(by);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(byArray, n, n2);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException("empty", illegalStateException);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        log.log(Level.FINE, "engineGetJCEAlgorithmString()");
        return this._macAlgorithm.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this._macAlgorithm.getProvider().getName();
    }

    protected void engineSetHMACOutputLength(int n) {
        this._HMACOutputLength = n;
    }

    protected void engineGetContextFromElement(Element element) throws XMLSignatureException {
        super.engineGetContextFromElement(element);
        if (element == null) {
            throw new XMLSignatureException("empty");
        }
        if (element.getChildNodes() != null && element.getChildNodes().getLength() > 0) {
            try {
                Element element2 = XMLUtils.createDSctx(element.getOwnerDocument(), "ds", "http://www.w3.org/2000/09/xmldsig#");
                Text text = (Text)XPathAPI.selectSingleNode(element, "./ds:HMACOutputLength/text()", element2);
                if (text != null) {
                    this._HMACOutputLength = Integer.parseInt(text.getData());
                }
            }
            catch (TransformerException transformerException) {
                throw new XMLSignatureException("empty", transformerException);
            }
        }
    }

    protected void engineAddContextToElement(Element element) throws XMLSignatureException {
        if (element == null) {
            throw new XMLSignatureException("empty");
        }
        if (this._HMACOutputLength != 0) {
            Document document = element.getOwnerDocument();
            Element element2 = XMLUtils.createElementInSignatureSpace(document, "HMACOutputLength");
            Text text = document.createTextNode(new Integer(this._HMACOutputLength).toString());
            element2.appendChild(text);
            XMLUtils.addReturnToElement(element);
            element.appendChild(element2);
            XMLUtils.addReturnToElement(element);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class IntegrityHmacMD5
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
        }
    }

    public static class IntegrityHmacRIPEMD160
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
        }
    }

    public static class IntegrityHmacSHA512
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
        }
    }

    public static class IntegrityHmacSHA384
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
        }
    }

    public static class IntegrityHmacSHA256
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
        }
    }

    public static class IntegrityHmacSHA1
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        }
    }
}

