/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.security.algorithms;

import com.sun.org.apache.xml.security.utils.XMLUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class JCEMapper {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$security$algorithms$JCEMapper == null ? (class$com$sun$org$apache$xml$security$algorithms$JCEMapper = JCEMapper.class$("com.sun.org.apache.xml.security.algorithms.JCEMapper")) : class$com$sun$org$apache$xml$security$algorithms$JCEMapper).getName());
    private static Map uriToJCEName = new HashMap();
    private static Map algorithmsMap = new HashMap();
    static /* synthetic */ Class class$com$sun$org$apache$xml$security$algorithms$JCEMapper;

    public static void init(Element element) throws Exception {
        JCEMapper.loadAlgorithms((Element)element.getElementsByTagName("Algorithms").item(0));
    }

    static void loadAlgorithms(Element element) {
        Element[] elementArray = XMLUtils.selectNodes(element.getFirstChild(), "http://www.xmlsecurity.org/NS/#configuration", "Algorithm");
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2 = elementArray[i];
            String string = element2.getAttribute("URI");
            String string2 = element2.getAttribute("JCEName");
            uriToJCEName.put(string, string2);
            algorithmsMap.put(string, new Algorithm(element2));
        }
    }

    public static String translateURItoJCEID(String string) {
        log.log(Level.FINE, "Request for URI " + string);
        return (String)uriToJCEName.get(string);
    }

    public static String getAlgorithmClassFromURI(String string) {
        log.log(Level.FINE, "Request for URI " + string);
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)string)).algorithmClass;
    }

    public static int getKeyLengthFromURI(String string) {
        return Integer.parseInt(((Algorithm)JCEMapper.algorithmsMap.get((Object)string)).keyLength);
    }

    public static String getJCEKeyAlgorithmFromURI(String string) {
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)string)).requiredKey;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Algorithm {
        String algorithmClass;
        String keyLength;
        String requiredKey;

        public Algorithm(Element element) {
            this.algorithmClass = element.getAttribute("AlgorithmClass");
            this.keyLength = element.getAttribute("KeyLength");
            this.requiredKey = element.getAttribute("RequiredKey");
        }
    }
}

