/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.j2se.MOAgents;

import com.sun.management.j2se.MOAgents.EmmaProxyBean;
import com.sun.management.j2se.MOAgents.MOAgentFactory;
import com.sun.management.j2se.MOAgents.MOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

class MOFactoryListener
implements NotificationListener {
    MBeanServer server = null;
    Hashtable proxyBeans = new Hashtable();

    public MOFactoryListener(MBeanServer s) throws MOException {
        this.server = s;
        try {
            ObjectName objName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            this.server.addNotificationListener(objName, this, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MOException("Cannot Create Factorty Notification Listener " + e);
        }
        this.convertNonEmmaBeans();
    }

    public void handleNotification(Notification n, Object o) {
        if (!(n instanceof MBeanServerNotification)) {
            return;
        }
        MBeanServerNotification mbsn = (MBeanServerNotification)n;
        ObjectName objName = mbsn.getMBeanName();
        MOAgentFactory.echo(" Got MBenaServer Notificaiton on: " + objName);
        if (MOAgentFactory.isEmmaAgent(objName)) {
            MOAgentFactory.echo(" This is a known Emma agent...no need to mess with it!\n");
            return;
        }
        String type = mbsn.getType();
        if (type.equalsIgnoreCase("JMX.mbean.registered")) {
            if (this.proxyBeans.get(objName) == null) {
                this.proxyBeans.put(objName, new EmmaProxyBean(objName, this.server));
                MOAgentFactory.echo(" Got a register of non-=emma agent\n");
            }
        } else if (type.equalsIgnoreCase("JMX.mbean.unregistered")) {
            MOAgentFactory.echo(" Got an Unregister of non-=emma agent\n");
            try {
                this.server.unregisterMBean((ObjectName)this.proxyBeans.get(objName));
                this.proxyBeans.remove(objName);
            }
            catch (Exception e) {
                System.out.println("Couldn't unregister EmmaProxyBean");
                e.printStackTrace();
            }
        }
    }

    void convertNonEmmaBeans() {
        Set<ObjectName> names;
        ObjectName objName;
        int i = 0;
        try {
            objName = new ObjectName("*:*");
            names = this.server.queryNames(objName, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (names == null) {
            return;
        }
        Object[] objs = names.toArray();
        MOAgentFactory.echo("--->convertNonEmmaBeans: names.size(): " + names.size());
        MOAgentFactory.echo("--->convertNonEmmaBeans: objs.length: " + objs.length);
        i = 0;
        while (i < objs.length) {
            objName = (ObjectName)objs[i];
            if (!MOAgentFactory.isEmmaAgent(objName)) {
                MOAgentFactory.echo("Scanner: Got a register of non-=emma agent\n");
                this.proxyBeans.put(objName, new EmmaProxyBean(objName, this.server));
            }
            ++i;
        }
    }

    void removeConvertedEmmaBeans() {
        Enumeration enumeration = this.proxyBeans.keys();
        while (enumeration.hasMoreElements()) {
            ObjectName o = (ObjectName)enumeration.nextElement();
            try {
                this.server.unregisterMBean((ObjectName)this.proxyBeans.get(o));
                this.proxyBeans.remove(o);
            }
            catch (Exception e) {
                System.out.println("Couldn't unregister EmmaProxyBean");
                e.printStackTrace();
            }
        }
    }
}

