/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.j2se.MOAgents;

import com.sun.management.j2se.MOAgents.EmmaAgentUtil;
import com.sun.management.j2se.MOAgents.EmmaManagedObjectInterface;
import com.sun.management.j2se.MOAgents.EmmaOptions;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

class EmmaProxyBean
implements DynamicMBean,
EmmaManagedObjectInterface,
NotificationBroadcaster {
    MBeanServer server;
    ObjectName objName;
    EmmaOptions emmaOptions;

    public EmmaProxyBean(ObjectName name, MBeanServer s) {
        this.server = s;
        this.objName = name;
        this.emmaOptions = new EmmaOptions();
        Hashtable<String, String> props = this.objName.getKeyPropertyList();
        Enumeration<String> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            this.emmaOptions.addKeyValue(key, props.get(key));
        }
        try {
            EmmaAgentUtil.register(this, this.server);
        }
        catch (Exception e) {
            System.out.println("Unexpected Excpetion encountered while attempting to proxy a non-Emma Bean");
            e.printStackTrace();
        }
    }

    public EmmaOptions getEmmaOptions() {
        return this.emmaOptions;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            return this.server.getAttribute(this.objName, attribute);
        }
        catch (Exception e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
    }

    public AttributeList getAttributes(String[] attributeNames) {
        try {
            return this.server.getAttributes(this.objName, attributeNames);
        }
        catch (Exception e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.server.setAttribute(this.objName, attribute);
        }
        catch (Exception e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        try {
            return this.server.setAttributes(this.objName, attributes);
        }
        catch (Exception e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
    }

    public Object invoke(String opName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            return this.server.invoke(this.objName, opName, params, signature);
        }
        catch (Exception e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
    }

    public MBeanInfo getMBeanInfo() {
        try {
            return this.server.getMBeanInfo(this.objName);
        }
        catch (Exception e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        try {
            this.server.addNotificationListener(this.objName, listener, filter, handback);
        }
        catch (Exception e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        try {
            this.server.removeNotificationListener(this.objName, listener);
        }
        catch (Exception e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        try {
            return this.server.getMBeanInfo(this.objName).getNotifications();
        }
        catch (Exception e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
    }
}

